/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.aggregation;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DurationType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.aggregation.AggregationLineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartSetting;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsHeaderPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatsSummaryPanel;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AggregationStatsPanel
extends StatisticsPanel {
    private static final long serialVersionUID = 1L;

    public AggregationStatsPanel(String id, StatisticsRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    @Override
    protected LineChart loadLineChart() {
        ArrayList series = Lists.newArrayList();
        StatisticsItem primaryItem = this.getPrimaryItem();
        LineChartData data = this.loadChartData(this.getConfiguration().getId(), primaryItem, this.chartOption.getPrimaryDateRange());
        series.add(data);
        if (this.isCompareToPast()) {
            data = this.loadChartData(this.getConfiguration().getId(), primaryItem, this.chartOption.getComparisonDateRange());
            series.add(data);
        } else {
            switch (this.chartOption.getCompareOption()) {
                case ONE_METRIC: {
                    break;
                }
                case OTHER_METRICS: {
                    List<StatisticsItem> comparisonItems = this.chartOption.getComparisonItems();
                    for (StatisticsItem each : comparisonItems) {
                        if (Objects.equal((Object)each, (Object)primaryItem)) continue;
                        data = this.loadChartData(this.getConfiguration().getId(), each, this.chartOption.getPrimaryDateRange());
                        series.add(data);
                    }
                    break;
                }
                case OTHER_CONFIGURATION: {
                    List<Long> comparisonIds = this.chartOption.getComparisonConfigs();
                    for (Long each : comparisonIds) {
                        if (Objects.equal((Object)each, (Object)this.getConfiguration().getId())) continue;
                        data = this.loadChartData(each, primaryItem, this.chartOption.getPrimaryDateRange());
                        series.add(data);
                    }
                    break;
                }
            }
        }
        return new LineChart(series, this.isShowBuildInfo(), this.chartOption);
    }

    @Override
    public boolean hasExcludingFailed() {
        return false;
    }

    @Override
    public boolean isShowBuildInfo() {
        return false;
    }

    @Override
    protected Component createStatsSummary(String id) {
        return new AggregationStatsSummaryPanel(id, this);
    }

    @Override
    protected Component createStatsHeader(String id) {
        return new StatisticsHeaderPanel(id, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component createDeleteLink(String id) {
                AjaxLink<Void> link = new AjaxLink<Void>(id){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        ReportCategory category = parentPanel.getRenderer().getCategory();
                        category.deleteReportSetOfAggregation(Context.getConfiguration(), parentPanel.getReportSet());
                        String[] reportsets = parentPanel.getReportSets();
                        if (reportsets.length == 0) {
                            this.setResponsePage((Page)new StatisticsPage(Context.getConfiguration().getId()));
                        } else {
                            SessionData.get().setReportSet(reportsets[0]);
                            target.add(new Component[]{parentPanel});
                        }
                    }

                    public void onConfigure() {
                        super.onConfigure();
                        this.setVisibilityAllowed(SecurityHelper.hasPermission((String)ConfigurationPermission.DELETE_REPORT.name()) && this.hasDeleteButtons() && parentPanel.getReportSets().length > 0);
                    }
                };
                link.add(new Behavior[]{new ConfirmBehavior((IModel)Model.of((Serializable)((Object)"Are you sure you want to permanent delete the current aggregation set?")))});
                return link;
            }

            @Override
            protected Component createDeleteAllLink(String id) {
                AjaxLink<Void> link = new AjaxLink<Void>("deleteAllLink"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        ReportCategory category = parentPanel.getRenderer().getCategory();
                        category.deleteAllReportSetsOfAggregation(Context.getConfiguration());
                        this.setResponsePage((Page)new StatisticsPage(Context.getConfiguration().getId()));
                    }

                    public void onConfigure() {
                        super.onConfigure();
                        this.setVisibilityAllowed(SecurityHelper.hasPermission((String)ConfigurationPermission.DELETE_REPORT.name()) && this.hasDeleteButtons() && this.hasMultipleReportSet());
                    }
                };
                link.add(new Behavior[]{new ConfirmBehavior((IModel)Model.of((Serializable)((Object)"Are you sure you want to permanent delete all aggregation sets?")))});
                return link;
            }
        };
    }

    protected LineChartData loadChartData(Long configId, StatisticsItem item, DateRange dateRange) {
        LineChartSetting setting = new LineChartSetting(item);
        setting.setDateRange(dateRange);
        switch (this.chartOption.getCompareOption()) {
            case ONE_METRIC: {
                if (this.isCompareToPast()) {
                    setting.setTitle(dateRange.format("MMM dd"));
                    break;
                }
                setting.setTitle(item.getTitle());
                break;
            }
            case OTHER_METRICS: {
                setting.setTitle(item.getTitle());
                break;
            }
            case OTHER_CONFIGURATION: {
                setting.setTitle(this.getConfiguration(configId).getName());
            }
        }
        AggregationLineChartData data = new AggregationLineChartData(setting, this.chartOption);
        if (!this.isShowReports()) {
            return data;
        }
        DataReport report = this.loadReport(configId, item, dateRange);
        if (report != null) {
            data.build(report);
        }
        return data;
    }

    protected DataReport loadReport(Long configId, StatisticsItem itme, DateRange dateRange) {
        ReportCategory category = this.getRenderer().getCategory();
        File dir = category.getReportDirOfAggregation(this.getConfiguration(configId), this.getReportSet());
        if (!dir.exists()) {
            return null;
        }
        return category.loadReport(dir, this.getRenderer().getReportName(), Restrictions.ge("day", dateRange.getBeginDate()), Restrictions.le("day", dateRange.getEndDate()));
    }

    @Override
    public String[] getReportSets() {
        ReportCategory category = this.getRenderer().getCategory();
        return category.getReportSetsOfAggregation(Context.getConfiguration());
    }

    @Override
    public boolean isByVersionDisabled() {
        return true;
    }

    static class AggregationStatsSummaryPanel
    extends StatsSummaryPanel {
        private static final long serialVersionUID = 1L;

        public AggregationStatsSummaryPanel(String id, StatisticsPanel parentPanel) {
            super(id, parentPanel);
        }

        @Override
        protected String getSummaryUnit(LineChartData data) {
            DataType dataType = data.getDataType();
            if (dataType instanceof DurationType) {
                return "(avg.)";
            }
            if (dataType instanceof PercentType) {
                return "(avg.)";
            }
            return data.getSetting().getTitle();
        }
    }
}

