/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.aggregation;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartSetting;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.util.DateRange;
import java.util.Date;
import java.util.List;

public class AggregationLineChartData
extends LineChartData {
    private static final long serialVersionUID = 1L;
    private int totalRows = 0;

    public AggregationLineChartData(LineChartSetting setting, LineChartOption chartOption) {
        super(setting, chartOption);
    }

    public void build(DataReport report) {
        Preconditions.checkNotNull((Object)this.chartOption, (Object)"ChartOption should be set before build chart data");
        Preconditions.checkNotNull((Object)this.setting, (Object)"ChartSetting should be set before build chart data");
        Preconditions.checkNotNull((Object)report, (Object)"Report should not be null");
        String columnName = this.setting.getItem().getValueExpression();
        if (!report.getMeta().hasColumn(columnName)) {
            return;
        }
        switch (this.chartOption.getGroupOption()) {
            case BY_VERSION: {
                throw new IllegalArgumentException("By version is not applicable to aggregation statistics");
            }
        }
        this.groupByDate(report);
    }

    @Override
    public String getSummaryInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Max: ").append(this.getDataType().asString(this.getMax())).append(", Min: ").append(this.getDataType().asString(this.getMin()));
        return sb.toString();
    }

    @Override
    public double getAverage() {
        return MathUtils.divide(this.totals, (Number)this.totalRows);
    }

    protected void groupByDate(DataReport report) {
        if (report.isEmpty()) {
            return;
        }
        this.totalRows = report.getRowsCount();
        String columnName = this.setting.getItem().getValueExpression();
        DateRange dateRange = this.setting.getDateRange();
        int count = this.getIntervalCount(dateRange);
        LineChartData.IndexTracker tracker = new LineChartData.IndexTracker();
        for (int i = 0; i <= count; ++i) {
            LineChartItem item = new LineChartItem();
            DateRange currentRange = this.getCurrentRange(dateRange.getBeginDate(), i, count);
            item.setDateRange(currentRange);
            LineChartData.PeriodData data = this.findPeriodData(report, currentRange, tracker);
            List<DataRow> periodRows = data.rows;
            double periodMax = 0.0;
            double periodMin = Double.MAX_VALUE;
            double periodTotals = 0.0;
            for (DataRow each : periodRows) {
                double value = each.getDouble(columnName);
                periodMax = Math.max(periodMax, value);
                periodMin = Math.min(periodMin, value);
                periodTotals += value;
            }
            this.totals += periodTotals;
            double periodValue = this.setting.getItem().isUseAverage() ? (periodRows.size() == 0 ? 0.0 : periodTotals / (double)periodRows.size()) : periodTotals;
            if (periodRows.size() > 0) {
                item.setValidBuilds(1);
                item.setTotalBuilds(1);
                if (this.setting.getItem().isUseAverage()) {
                    this.max = Math.max(this.max, periodValue);
                    this.min = Math.min(this.min, periodValue);
                } else {
                    this.max = Math.max(this.max, periodMax);
                    this.min = Math.min(this.min, periodMin);
                }
                this.periodMax = Math.max(this.periodMax, periodValue);
                this.periodMin = Math.min(this.periodMin, periodValue);
            }
            item.setValue(periodValue);
            item.setMax(periodMax);
            item.setMin(periodMin);
            this.addItem(item);
        }
    }

    protected LineChartData.PeriodData findPeriodData(DataReport report, DateRange range, LineChartData.IndexTracker tracker) {
        DataRow row;
        Date date;
        LineChartData.PeriodData data = new LineChartData.PeriodData(this);
        for (int i = tracker.nextRow; i < report.getRowsCount() && !(date = (Date)DataTypes.DATE.typeCast((row = report.getRow(i)).getValue("day"))).after(range.getEndDate()); ++i) {
            if (!range.contains(date)) continue;
            data.rows.add(row);
            ++tracker.nextRow;
        }
        return data;
    }
}

