/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer;

import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ExecutionContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.LineChartOption;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;

public class SessionData
extends ExecutionContext {
    private static final long serialVersionUID = 1L;
    private static final String KEY = SessionData.class.getName();
    private static final String REPORT_FILTER = KEY + ".reportfilter";
    private static final String REPORT_SET = KEY + ".reportset";
    private static final String CATEGORY_ID = KEY + ".categoryid";
    private static final String CONFIGURATION_ID = KEY + ".configurationid";
    private static final String COMPARISON_BUILD = KEY + ".comparisonbuild";
    private static final String LINE_CHART_OPTION = KEY + ".viewoptions";

    public ReportFilter getFilter() {
        ReportFilter filter = (ReportFilter)this.get(REPORT_FILTER);
        if (filter == null) {
            filter = new ReportFilter();
            this.setFilter(filter);
        }
        return filter;
    }

    public void setFilter(ReportFilter filter) {
        this.put(REPORT_FILTER, filter);
    }

    public void clearFilter() {
        ReportFilter f = this.getFilter();
        f.clear();
    }

    public String getReportSet() {
        return (String)this.get(REPORT_SET);
    }

    public void setReportSet(String reportset) {
        this.put(REPORT_SET, reportset);
    }

    public String getCategoryId() {
        return (String)this.get(CATEGORY_ID);
    }

    public void setCategoryId(String categoryId) {
        this.put(CATEGORY_ID, categoryId);
    }

    public Long getConfigurationId() {
        return (Long)this.get(CONFIGURATION_ID);
    }

    public void setConfigurationId(Long id) {
        this.put(CONFIGURATION_ID, id);
    }

    public Pair<Long, String> getComparisonBuild() {
        return (Pair)this.get(COMPARISON_BUILD);
    }

    public void setComparisonBuild(Pair<Long, String> comparison) {
        this.put(COMPARISON_BUILD, comparison);
    }

    public LineChartOption getLineChartOption() {
        LineChartOption option = (LineChartOption)this.get(LINE_CHART_OPTION);
        if (option == null) {
            option = new LineChartOption();
            this.setLineChartOption(option);
        }
        return option;
    }

    public void setLineChartOption(LineChartOption option) {
        this.put(LINE_CHART_OPTION, option);
    }

    public static SessionData get() {
        SessionData data = (SessionData)WebSession.get().getData().get(SessionData.getKey());
        if (data == null) {
            data = new SessionData();
            SessionData.set(data);
        }
        return data;
    }

    public static void set(SessionData data) {
        WebSession.get().getData().put(SessionData.getKey(), data);
    }

    public static String getKey() {
        BasePage page = BasePage.get();
        if (page instanceof StatisticsPage) {
            return page.getClass().getName() + ":" + KEY;
        }
        if (page instanceof ConfigurationOverview) {
            return page.getClass().getName() + ":" + KEY;
        }
        return "BuildPage:" + KEY;
    }
}

