/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.DefaultHeaderPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportSetChanged;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class DefaultReportPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final AbstractRenderer renderer;
    private String reportset;

    public DefaultReportPanel(String id, AbstractRenderer renderer, IModel<RendererContext> model) {
        super(id, model);
        this.renderer = renderer;
        this.setOutputMarkupId(true);
        this.reportset = this.getContext().getReportSet();
        Preconditions.checkNotNull((Object)this.reportset, (Object)"Reportset must be set before initialize DefaultReportPanel.");
    }

    public void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createHeader("header")});
        this.add(new Component[]{this.createContent("content")});
    }

    public RendererContext getContext() {
        return (RendererContext)this.getDefaultModelObject();
    }

    protected Component createHeader(String id) {
        return new DefaultHeaderPanel(id, this, (IModel<RendererContext>)this.getDefaultModel());
    }

    protected Panel createContent(String id) {
        return this.renderer.createReportPanel(id, (IModel<RendererContext>)this.getDefaultModel());
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }

    public String getReportset() {
        return this.reportset;
    }

    public void setReportset(String reportset) {
        this.reportset = reportset;
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof ReportSetChanged) {
            this.onEvent((ReportSetChanged)sink.getPayload());
        } else if (sink.getPayload() instanceof AjaxEvent) {
            this.onEvent((AjaxEvent)sink.getPayload());
        }
    }

    public void onEvent(ReportSetChanged event) {
        this.reportset = event.getReportset();
        SessionData.get().setReportSet(this.reportset);
    }

    public void onEvent(AjaxEvent event) {
    }

    public Build getBuild() {
        return Context.getBuild();
    }

    public Configuration getConfiguration() {
        return Context.getConfiguration();
    }

    public Panel getContentPanel() {
        return (Panel)this.get("content");
    }

    public DataReport getDefaultDataReport() {
        Panel p = this.getContentPanel();
        if (p instanceof AbstractReportPanel) {
            return ((AbstractReportPanel)p).getDefaultReport();
        }
        return null;
    }

    public IModel<File> getExportFileModel() {
        return new LoadableDetachableModel<File>(){
            private static final long serialVersionUID = 1L;

            protected File load() {
                AbstractReportPanel content;
                DataReport report;
                Panel panel = (Panel)DefaultReportPanel.this.get("content");
                File tmpFile = FileUtils.createTempFile((String)"report-", (String)".xml");
                if (panel instanceof AbstractReportPanel && (report = (content = (AbstractReportPanel)panel).getDefaultReport()) != null) {
                    report.saveToXML(tmpFile);
                }
                return tmpFile;
            }
        };
    }
}

