/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.DefaultReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.ExportFormat;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.web.DropDownChoiceWithAjaxIndicator;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportSetChanged;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQConfirmLink;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.EnclosureContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class DefaultHeaderPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final DefaultReportPanel parentPanel;

    public DefaultHeaderPanel(String id, DefaultReportPanel parent, IModel<RendererContext> model) {
        super(id, model);
        this.parentPanel = parent;
        this.setOutputMarkupId(true);
    }

    public void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("title", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return DefaultHeaderPanel.this.getTitle();
            }
        }).setEscapeModelStrings(false).setOutputMarkupId(true)});
        String description = this.getDescription();
        if (Strings.isNullOrEmpty((String)description)) {
            this.add(new Component[]{new WebMarkupContainer("description").setVisible(false)});
        } else {
            this.add(new Component[]{new Label("description", description)});
        }
        ReportSetForm reportsetForm = new ReportSetForm("reportsetForm");
        EnclosureContainer ec = new EnclosureContainer("formContainer", (Component)reportsetForm);
        ec.add(new Component[]{reportsetForm});
        this.add(new Component[]{ec});
        AbstractLink exportLink = new AbstractLink("exportLink"){};
        this.add(new Component[]{exportLink});
        exportLink.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList items = Lists.newArrayList();
                for (ExportFormat each : ExportFormat.values()) {
                    items.add(new ExportMenuItem(each));
                }
                return items;
            }
        }});
        if (this.parentPanel.getRenderer().getMode() == RendererMode.STATISTICS && SecurityHelper.hasPermission((String)ConfigurationPermission.DELETE_REPORT.name())) {
            this.add(new Component[]{new JQConfirmLink<Void>("deleteLink", "Are you sure you want to permanent delete this report set?"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Configuration configuration = DefaultHeaderPanel.this.parentPanel.getConfiguration();
                    DefaultHeaderPanel.this.parentPanel.getRenderer().getCategory().deleteReportSetOfStats(configuration, DefaultHeaderPanel.this.parentPanel.getReportset());
                    String reportset = DefaultHeaderPanel.this.getNextAvailableReportSet();
                    if (reportset == null) {
                        this.setResponsePage((Page)new StatisticsPage(configuration.getId()));
                    } else {
                        this.send((IEventSink)DefaultHeaderPanel.this.parentPanel, Broadcast.DEPTH, new ReportSetChanged(target, reportset));
                    }
                }

                public void onConfigure() {
                    super.onConfigure();
                    this.setVisibilityAllowed(DefaultHeaderPanel.this.getReportSets().size() > 0);
                }
            }});
            this.add(new Component[]{new JQConfirmLink<Void>("deleteAllLink", (IModel)Model.of((Serializable)((Object)"Are you sure you want to permanent delete all report sets?"))){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    Configuration configuration = DefaultHeaderPanel.this.parentPanel.getConfiguration();
                    DefaultHeaderPanel.this.parentPanel.getRenderer().getCategory().deleteAllReportSetsOfStats(configuration);
                    this.setResponsePage((Page)new StatisticsPage(configuration.getId()));
                }

                public void onConfigure() {
                    super.onConfigure();
                    this.setVisibilityAllowed(DefaultHeaderPanel.this.getReportSets().size() > 1);
                }
            }});
        } else {
            this.add(new Component[]{new WebMarkupContainer("deleteLink").setVisible(false)});
            this.add(new Component[]{new WebMarkupContainer("deleteAllLink").setVisible(false)});
        }
    }

    private String getNextAvailableReportSet() {
        List<String> reportsets = this.getReportSets();
        if (reportsets.isEmpty()) {
            return null;
        }
        return reportsets.get(0);
    }

    private List<String> getReportSets() {
        File categoryDir;
        AbstractRenderer renderer = this.parentPanel.getRenderer();
        ReportCategory category = renderer.getCategory();
        switch (renderer.getMode()) {
            case STATISTICS: {
                categoryDir = category.getCategoryDirOfStats(this.parentPanel.getConfiguration());
                break;
            }
            default: {
                categoryDir = category.getCategoryDirOfBuild(this.parentPanel.getBuild());
            }
        }
        return Lists.newArrayList((Object[])category.getReportSets(categoryDir));
    }

    public String getTitle() {
        String title = this.parentPanel.renderer.getTitle();
        if (this.parentPanel.getReportset() == null || "DEFAULT".equalsIgnoreCase(this.parentPanel.getReportset())) {
            return title;
        }
        return title + " <span class='light-text'>(" + this.parentPanel.getReportset() + ")</span>";
    }

    public String getDescription() {
        return this.parentPanel.renderer.getDescription();
    }

    public void onEvent(ReportSetChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    class ReportSetForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public ReportSetForm(String id) {
            super(id);
            DropDownChoiceWithAjaxIndicator reportSetSelector = new DropDownChoiceWithAjaxIndicator("reportSetSelector", (IModel)new PropertyModel((Object)DefaultHeaderPanel.this.parentPanel, "reportset"), (IModel)new AbstractReadOnlyModel<List<String>>(){
                private static final long serialVersionUID = 1L;

                public List<String> getObject() {
                    return DefaultHeaderPanel.this.getReportSets();
                }
            });
            reportSetSelector.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (DefaultHeaderPanel.this.parentPanel.getRenderer().getMode() == RendererMode.BUILD) {
                        PageParameters params = BuildPage.params4((Long)Context.getBuild().getId(), (String[])new String[]{Tab.title2id((String)DefaultHeaderPanel.this.parentPanel.getRenderer().getCategory().getName()), Tab.title2id((String)DefaultHeaderPanel.this.parentPanel.getRenderer().getTabName())});
                        params.add("reportset", (Object)DefaultHeaderPanel.this.parentPanel.getReportset());
                        ReportSetForm.this.setResponsePage(BuildPage.class, params);
                    } else if (DefaultHeaderPanel.this.parentPanel.getRenderer().getMode() == RendererMode.STATISTICS) {
                        PageParameters params = StatisticsPage.params4((Long)Context.getConfiguration().getId(), (String[])new String[]{Tab.title2id((String)DefaultHeaderPanel.this.parentPanel.getRenderer().getCategory().getName()), Tab.title2id((String)DefaultHeaderPanel.this.parentPanel.getRenderer().getTabName())}, (Map)ImmutableMap.of((Object)"reportset", (Object)DefaultHeaderPanel.this.parentPanel.getReportset()));
                        ReportSetForm.this.setResponsePage(StatisticsPage.class, params);
                    } else {
                        ReportSetForm.this.send((IEventSink)DefaultHeaderPanel.this.parentPanel, Broadcast.DEPTH, new ReportSetChanged(target, DefaultHeaderPanel.this.parentPanel.getReportset()));
                    }
                }
            }});
            this.add(new Component[]{reportSetSelector});
        }

        public void onConfigure() {
            super.onConfigure();
            List reportsets = DefaultHeaderPanel.this.getReportSets();
            this.setVisibilityAllowed(reportsets.size() > 1);
        }
    }

    class ExportMenuItem
    extends MenuItem {
        final ExportFormat fileType;

        ExportMenuItem(ExportFormat ft) {
            this.fileType = ft;
        }

        public Component render(String componentId) {
            return new LinkPanel(componentId, this.fileType.name(), true){

                @Override
                protected AbstractLink createLink(String id) {
                    return new DownloadLink(id, ExportMenuItem.this.getFileModel(), ExportMenuItem.this.getFileName()).setDeleteAfterDownload(true);
                }
            };
        }

        private IModel<File> getFileModel() {
            return new LoadableDetachableModel<File>(){

                protected File load() {
                    DataReport report = DefaultHeaderPanel.this.parentPanel.getDefaultDataReport();
                    File tmp = FileUtils.createTempFile((String)"report", (String)ExportMenuItem.this.fileType.name().toLowerCase());
                    if (report != null) {
                        switch (ExportMenuItem.this.fileType) {
                            case XML: {
                                report.saveToXML(tmp);
                                break;
                            }
                            case CSV: {
                                FileWriter fw = null;
                                try {
                                    fw = new FileWriter(tmp);
                                    report.toCSV(fw);
                                }
                                catch (IOException e) {
                                    try {
                                        throw Throwables.propagate((Throwable)e);
                                    }
                                    catch (Throwable throwable) {
                                        IOUtils.closeQuietly(fw);
                                        throw throwable;
                                    }
                                }
                                IOUtils.closeQuietly((Writer)fw);
                                break;
                            }
                            case TSV: {
                                FileWriter fw = null;
                                try {
                                    fw = new FileWriter(tmp);
                                    report.toTSV(fw);
                                }
                                catch (IOException e) {
                                    try {
                                        throw Throwables.propagate((Throwable)e);
                                    }
                                    catch (Throwable throwable) {
                                        IOUtils.closeQuietly(fw);
                                        throw throwable;
                                    }
                                }
                                IOUtils.closeQuietly((Writer)fw);
                                break;
                            }
                        }
                    }
                    return tmp;
                }
            };
        }

        private String getFileName() {
            return DefaultHeaderPanel.this.parentPanel.getRenderer().getTitle() + "." + this.fileType.name().toLowerCase();
        }
    }
}

