/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStatsMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.StatsQuery;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.datatype.LongType;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportFilterChanged;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportSetChanged;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public abstract class AbstractReportPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final AbstractRenderer renderer;
    private final IModel<DataReport> defaultReportModel;
    private final IModel<ReportStats> statsModel;
    private transient Map<String, Object> data = Maps.newHashMap();
    private String reportset;

    public AbstractReportPanel(String id, AbstractRenderer renderer, IModel<RendererContext> model) {
        super(id, model);
        this.renderer = renderer;
        this.reportset = this.getContext().getReportSet();
        Preconditions.checkNotNull((Object)this.reportset, (Object)"Reportset must be set before render report panel.");
        this.setOutputMarkupId(true);
        this.statsModel = new LoadableDetachableModel<ReportStats>(){
            private static final long serialVersionUID = 1L;

            protected ReportStats load() {
                return AbstractReportPanel.this.loadReportStats();
            }
        };
        this.defaultReportModel = new LoadableDetachableModel<DataReport>(){
            private static final long serialVersionUID = 1L;

            protected DataReport load() {
                return AbstractReportPanel.this.loadDefaultReport();
            }
        };
    }

    public String loadJavaScript() {
        String script;
        StringBuffer sb = new StringBuffer();
        sb.append("$('#").append(this.getMarkupId()).append(" .bar').each(function() {var w = $(this).attr('rel'); $(this).animate({width: w});});");
        String defaultScript = this.getDefaultScript();
        if (!Strings.isNullOrEmpty((String)defaultScript)) {
            sb.append(defaultScript);
        }
        if (!Strings.isNullOrEmpty((String)(script = this.renderer.getScript()))) {
            sb.append(script);
        }
        if (!Strings.isNullOrEmpty((String)(script = sb.toString()))) {
            script = ReportHelper.evaluateVelocity(script, this.buildScriptContext());
            sb = new StringBuffer();
            sb.append(script);
            return sb.toString();
        }
        return null;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String javascript = this.loadJavaScript();
        if (!Strings.isNullOrEmpty((String)javascript)) {
            response.renderOnDomReadyJavaScript(javascript);
        }
    }

    protected void onInitialize() {
        super.onInitialize();
    }

    protected String getDefaultScript() {
        return null;
    }

    protected Map<String, Object> buildScriptContext() {
        String markupId = this.getMarkupId();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("panelId", markupId);
        return context;
    }

    public ReportDataSource getDataSource() {
        return this.renderer.getDataSource();
    }

    protected DataReport createReport() {
        ReportDataSource rds = this.renderer.getDataSource();
        return this.renderer.getCategory().createReport(rds.getMainTable());
    }

    protected ReportStatsMetaData getStatsMeta() {
        ReportMetaData meta = this.renderer.getMeta();
        if (meta == null) {
            ReportStatsMetaData statsMeta = new ReportStatsMetaData();
            statsMeta.addColumn(new DataColumn("TOTALS", new LongType()));
            return statsMeta;
        }
        return new ReportStatsMetaData(meta, true);
    }

    public List<Filter> getFilters() {
        ReportMetaData meta;
        ReportFilter actual = new ReportFilter();
        ReportFilter reportFilter = this.getContext().getReportFilter();
        actual.addReportFilter(reportFilter);
        if (!this.renderer.isInDropDown() && !this.renderer.isIgnoreSessionFilter()) {
            reportFilter = SessionData.get().getFilter();
            actual.addReportFilter(reportFilter);
        }
        if ((meta = this.getRenderer().getMeta()) == null) {
            return actual.getAllFilters();
        }
        Set<String> names = actual.getAllColumnNames();
        for (String column : names) {
            int pos = column.indexOf(".");
            if (meta.hasColumn(column = column.substring(pos + 1))) continue;
            actual.remove(column);
        }
        return actual.getAllFilters();
    }

    public DataReport getDefaultReport() {
        return (DataReport)this.defaultReportModel.getObject();
    }

    public boolean isShowReports() {
        return ReportHelper.isShowReports(this.renderer.getCategory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportStats loadReportStats() {
        long start = System.currentTimeMillis();
        List<StatsQuery> queries = this.getStatsQueries();
        ReportDataSource rds = this.renderer.getDataSource();
        List<Filter> filters = this.getFilters();
        ReportStats stats = new ReportStats(this.getStatsMeta());
        DataRow row = stats.addRow();
        File dbDir = this.getDbDir();
        if (!dbDir.exists() || !this.isShowReports()) {
            return stats;
        }
        CategoryDb db = this.renderer.getCategory().getCategoryDb(dbDir);
        if (!db.exists()) {
            return stats;
        }
        try {
            db.open(DbStore.Mode.READ_ONLY, "AbstractReportPanel::loadReportStats");
            for (StatsQuery each : queries) {
                SqlBuilder query = rds.toQuery(this.getContext().getExpressionContext());
                query.getSelectColumns().clear();
                query.select(each.getSelectColumns());
                query.where(filters);
                query.clearOrderBy();
                query.clearGroupBy();
                query.setLimit(0);
                if (each.isForEnum()) {
                    String columnName = each.getSelectColumns()[0];
                    query.groupby(columnName);
                    List<Object[]> list = db.queryForArrayList(query);
                    for (Object[] array : list) {
                        String enumValue = (String)array[0];
                        if (Strings.isNullOrEmpty((String)enumValue)) continue;
                        Object value = array[1];
                        row.setValue(columnName + "_" + enumValue, value);
                    }
                    continue;
                }
                Map<String, Object> result = db.queryForMap(query);
                for (String key : result.keySet()) {
                    row.setValue(key, result.get(key));
                }
            }
            ReportStats reportStats = stats;
            return reportStats;
        }
        finally {
            db.close();
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Load report stats cost: " + (System.currentTimeMillis() - start) + " millis");
            }
        }
    }

    public ReportStats getReportStats() {
        return (ReportStats)this.statsModel.getObject();
    }

    protected List<StatsQuery> getStatsQueries() {
        List<StatsQuery> list = this.renderer.getStatsQueries();
        if (list.isEmpty()) {
            StatsQuery query = new StatsQuery();
            query.setForEnum(false);
            query.setSelectColumns(new String[]{"COUNT(*) AS TOTALS"});
            return Lists.newArrayList((Object[])new StatsQuery[]{query});
        }
        return list;
    }

    protected DataReport loadDefaultReport() {
        return this.loadReport(this.createQuery());
    }

    protected SqlBuilder createQuery() {
        ReportDataSource rds = this.renderer.getDataSource();
        if (rds == null) {
            return null;
        }
        SqlBuilder query = rds.toQuery(this.getContext().getExpressionContext());
        query.where(this.getFilters());
        return query;
    }

    protected DataReport loadReport(SqlBuilder query) {
        DataReport passthrough = this.getContext().getPassthroughReport();
        if (passthrough != null) {
            return passthrough;
        }
        ReportCategory category = this.renderer.getCategory();
        File dbDir = this.getDbDir();
        if (!dbDir.exists() || !this.isShowReports()) {
            return category.createReport(this.renderer.getReportName());
        }
        return category.loadReport(dbDir, query);
    }

    public RendererContext getContext() {
        return (RendererContext)this.getDefaultModelObject();
    }

    protected Build getBuild() {
        Build b = this.getContext().getBuild();
        if (b != null) {
            return b;
        }
        return Context.getBuild();
    }

    protected Configuration getConfiguration() {
        Configuration c = this.getContext().getConfiguration();
        if (c == null) {
            return Context.getConfiguration();
        }
        return c;
    }

    public File getDbDir() {
        File dbDir;
        ReportCategory category = this.renderer.getCategory();
        switch (this.renderer.getMode()) {
            case STATISTICS: {
                dbDir = category.getReportDirOfStats(this.getConfiguration(), this.getReportSet());
                break;
            }
            case AGGREGATION_OVERVIEW: 
            case AGGREGATION_STATS: {
                dbDir = category.getReportDirOfAggregation(this.getConfiguration(), this.getReportSet());
                break;
            }
            default: {
                dbDir = category.getReportDirOfBuild(this.getBuild(), this.getReportSet());
            }
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Report dir: " + dbDir);
        }
        return dbDir;
    }

    public String getReportSet() {
        return this.reportset;
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }

    public void onAjaxEvent(AjaxEvent event) {
        String javascript = this.loadJavaScript();
        if (!Strings.isNullOrEmpty((String)javascript)) {
            event.getTarget().appendJavaScript((CharSequence)javascript);
        }
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof ReportSetChanged) {
            this.onEvent((ReportSetChanged)sink.getPayload());
        } else if (sink.getPayload() instanceof ReportFilterChanged) {
            this.onEvent((ReportFilterChanged)sink.getPayload());
        } else if (sink.getPayload() instanceof AjaxEvent) {
            this.onAjaxEvent((AjaxEvent)sink.getPayload());
        }
    }

    public void onEvent(ReportSetChanged event) {
        this.onAjaxEvent(event);
        this.reportset = event.getReportset();
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(ReportFilterChanged event) {
        ReportFilter filter = event.getFilter();
        SessionData.get().setFilter(filter);
        event.getTarget().add(new Component[]{this});
    }

    public Map<String, Object> getData() {
        if (this.data == null) {
            this.data = Maps.newHashMap();
        }
        return this.data;
    }

    public void onDetach() {
        this.defaultReportModel.detach();
        this.statsModel.detach();
        super.onDetach();
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }
}

