/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.StatsQuery;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ReportRenderer;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.DefaultReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.ReportDisabledPanel;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.web.component.LazyLoadPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractRenderer
extends AbstractCategoryItem
implements ReportRenderer {
    private static final long serialVersionUID = 1L;
    @Alias
    private String id;
    @Alias
    private int order = 999;
    @Alias
    private String title;
    @Alias
    private String tabName;
    @Alias
    private String description;
    @Alias
    private RendererMode mode = RendererMode.BUILD;
    @Alias
    private boolean contentOnly = false;
    @Alias
    private String css;
    @Alias
    private boolean lazyload = false;
    @Alias
    private boolean inDropDown = false;
    @Alias
    private boolean ignoreSessionFilter = false;
    @Alias
    private String script;
    private boolean isInGadget = false;
    private ReportDataSource dataSource;
    private List<StatsQuery> statsQueries = Lists.newArrayList();
    private AbstractRenderer parentRenderer;

    public AbstractRenderer(ReportCategory category) {
        super(category);
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    public abstract Panel createReportPanel(String var1, IModel<RendererContext> var2);

    public Panel createDefaultPanel(String id, IModel<RendererContext> model) {
        if (ReportHelper.isShowReports(this.getCategory())) {
            return new DefaultReportPanel(id, this, model);
        }
        return new ReportDisabledPanel(id);
    }

    @Override
    public Panel render(String id, final IModel<RendererContext> model) {
        if (this.contentOnly) {
            if (this.isLazyload()) {
                return new LazyLoadPanel(id){
                    private static final long serialVersionUID = 1L;

                    public Component getLazyLoadComponent(String markupId) {
                        return AbstractRenderer.this.createReportPanel(markupId, (IModel<RendererContext>)model);
                    }
                };
            }
            return this.createReportPanel(id, model);
        }
        return this.createDefaultPanel(id, model);
    }

    @Override
    public String getElementName() {
        return "renderer";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTabName() {
        if (Strings.isNullOrEmpty((String)this.tabName)) {
            return this.title;
        }
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RendererMode getMode() {
        if (this.mode == null) {
            AbstractRenderer parent = this.parentRenderer;
            while (parent != null) {
                if (parent.getMode() == null) continue;
                return parent.getMode();
            }
            return null;
        }
        return this.mode;
    }

    public void setMode(RendererMode mode) {
        this.mode = mode;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public ReportDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ReportDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void fromXML(Element node) {
        List nodes;
        Element e;
        super.fromXML(node);
        if (Strings.isNullOrEmpty((String)this.tabName)) {
            this.tabName = this.title;
        }
        if ((e = node.element("data-source")) != null) {
            this.dataSource = new ReportDataSource(this.category);
            this.dataSource.fromXML(e);
        }
        if (!(nodes = node.elements("stats-sql")).isEmpty()) {
            for (Element each : nodes) {
                Boolean withDefault = XMLHelper.getBoolean((Node)each, "useDefault", false);
                if (withDefault.booleanValue()) {
                    ReportMetaData meta = this.category.getMeta(this.dataSource.getMainTable());
                    this.statsQueries.addAll(meta.getStatsQueries());
                    continue;
                }
                StatsQuery sql = new StatsQuery();
                sql.fromXML(each);
                this.statsQueries.add(sql);
            }
        }
    }

    public void setUseDefaultStats() {
        ReportMetaData meta = this.getMeta();
        if (meta != null) {
            this.statsQueries.addAll(this.getMeta().getStatsQueries());
        }
    }

    public List<StatsQuery> getStatsQueries() {
        return ImmutableList.copyOf(this.statsQueries);
    }

    public void setStatsQueries(List<StatsQuery> statsQueries) {
        this.statsQueries = statsQueries;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String cssClass) {
        this.css = cssClass;
    }

    public boolean isLazyload() {
        return this.lazyload;
    }

    public void setLazyload(boolean lazyload) {
        this.lazyload = lazyload;
    }

    public boolean isInDropDown() {
        return this.inDropDown;
    }

    public void setInDropDown(boolean inDropDown) {
        this.inDropDown = inDropDown;
    }

    public boolean isInGadget() {
        return this.isInGadget;
    }

    public void setInGadget(boolean isInGadget) {
        this.isInGadget = isInGadget;
    }

    public AbstractRenderer getParentRenderer() {
        return this.parentRenderer;
    }

    public void setParentRenderer(AbstractRenderer parentRenderer) {
        this.parentRenderer = parentRenderer;
    }

    public String getReportName() {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getMainTable();
    }

    public ReportMetaData getMeta() {
        if (this.dataSource == null) {
            return null;
        }
        String table = this.dataSource.getMainTable();
        return this.category.getMeta(table);
    }

    public boolean isIgnoreSessionFilter() {
        return this.ignoreSessionFilter;
    }

    public void setIgnoreSessionFilter(boolean ignoreSessionFilter) {
        this.ignoreSessionFilter = ignoreSessionFilter;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String toString() {
        return this.getId() + " @ " + this.category.getId();
    }
}

