/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.migration;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;

public class VersionFile {
    private final File file;
    public static final String START_VERSION = "0";

    public VersionFile(File file) {
        this.file = file;
    }

    public String read() {
        if (!this.file.exists()) {
            return START_VERSION;
        }
        Lock lock = LockUtils.lockForRead((File)this.file);
        try {
            String line = Files.readFirstLine((File)this.file, (Charset)Charsets.UTF_8);
            if (Strings.isNullOrEmpty((String)line)) {
                String string = START_VERSION;
                return string;
            }
            if (line.contains("xml")) {
                String string = (String)BeanUtils.readFile((File)this.file);
                return string;
            }
            String string = line;
            return string;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public void write(String version) {
        Lock lock = LockUtils.lockForWrite((File)this.file);
        try {
            Files.write((CharSequence)version, (File)this.file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }
}

