/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.migration;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportCategoryMigrator {
    private static final Logger logger = LoggerFactory.getLogger(ReportCategoryMigrator.class);

    private void migrate1(MigrationContext context, Stack<Integer> versions) throws IOException {
    }

    private void migrate2(MigrationContext context, Stack<Integer> versions) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate3(MigrationContext context, Stack<Integer> versions) throws IOException {
        String[] reportsets;
        ReportCategory category = (ReportCategory)context.getCurrentBean();
        logger.debug("After upgrading to h2 1.3.175, opening old h2 database can cause READ_ONLY exception, opening it in READ_WRITE mode for first time ...");
        File dir = context.getDir();
        for (String each : reportsets = category.getReportSets(dir)) {
            File reportDir = new File(dir, each);
            CategoryDb db = category.getCategoryDb(reportDir);
            try {
                db.open(DbStore.Mode.READ_WRITE, "ReportCategoryMigrator:migrate3");
            }
            finally {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateFromXMLToH2(MigrationContext context) {
        ReportCategory category = (ReportCategory)context.getCurrentBean();
        logger.info("Migrating category " + category.getId() + " from XML report to H2 ...");
        File dir = context.getDir();
        String[] reportsets = category.getReportSets(dir);
        ReportMetaData[] metas = category.getMetas();
        try {
            for (String each : reportsets) {
                File reportDir = new File(dir, each);
                CategoryDb db = category.getCategoryDb(reportDir);
                try {
                    Configuration configuration;
                    db.open(DbStore.Mode.READ_WRITE, "ReportCategoryMigrator::migrateFromXMLToH2");
                    for (ReportMetaData meta : metas) {
                        this.report3To4(meta, context, db);
                    }
                    Build build = context.getBuild();
                    if (build != null) {
                        this.buildStats3To4(context, db);
                    }
                    if ((configuration = context.getConfiguration()) == null) continue;
                    this.stats3To4(context, db);
                }
                finally {
                    db.close();
                }
            }
        }
        catch (Exception e) {
            Collection updated = FileUtils.listFiles((File)dir, (String)"**/*.h2.db");
            for (File each : updated) {
                FileUtils.deleteFile((File)each);
            }
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    protected void report3To4(ReportMetaData meta, MigrationContext context, CategoryDb db) {
        DataReport report = new DataReport(meta);
        File file = new File(db.getDbDir(), report.getOutputName());
        if (!file.exists()) {
            return;
        }
        report.loadFromXML(file);
        db.saveReport(report);
    }

    protected void buildStats3To4(MigrationContext context, CategoryDb db) {
        throw new UnsupportedOperationException("Please override this function in the sub-plugin migration");
    }

    protected void stats3To4(MigrationContext context, CategoryDb db) {
        File reportDir = db.getDbDir();
        if (!reportDir.exists()) {
            return;
        }
        ReportCategory category = db.getCategory();
        Collection files = FileUtils.listFiles((File)reportDir, (String)"**/stats.xml");
        ReportMetaData meta = category.getMeta("stats");
        HashSet set = Sets.newHashSet();
        for (File file : files) {
            DataReport report = new DataReport(meta);
            report.loadFromXML(file);
            for (DataRow each : report.getRows()) {
                Long buildId = each.getLong("buildId");
                if (set.contains(buildId)) {
                    SqlBuilder sql = SqlBuilder.deleteFrom("stats").where(Restrictions.eq("buildId", buildId));
                    db.update(sql);
                }
                db.persistRow(each);
                set.add(buildId);
            }
        }
    }
}

