/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.migration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.VersionFile;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MigrationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MigrationExecutor.class);
    protected final File dir;
    protected final MigrationContext context;

    public abstract Class<?> getMigratorClass();

    protected abstract String getVersionFileName();

    public MigrationExecutor(File dir, MigrationContext context) {
        Preconditions.checkArgument((dir != null ? 1 : 0) != 0);
        this.context = context;
        this.dir = dir;
    }

    protected File getVersionFile() {
        return new File(this.dir, this.getVersionFileName());
    }

    public String readDataVersion() {
        return new VersionFile(this.getVersionFile()).read();
    }

    public void writeDataVersion() {
        File versionFile = this.getVersionFile();
        if (!this.dir.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Report directory " + this.dir + " doesn't exists. Do you configure the data directory correctly?");
            }
            return;
        }
        new VersionFile(versionFile).write(this.getCurrentVersion());
    }

    protected void beforeUpgrade() {
    }

    protected void afterUpgrade() {
    }

    protected void doUpgrade() {
        String appVersion;
        if (!this.needUpgrade()) {
            return;
        }
        String dataVersion = this.readDataVersion();
        if (Objects.equal((Object)dataVersion, (Object)(appVersion = this.getCurrentVersion()))) {
            logger.info("Already upgraded to the latest version by another thread.");
            return;
        }
        if (dataVersion.indexOf(46) < 0) {
            dataVersion = dataVersion + ".0";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Upgrading data from version " + dataVersion + " to version " + appVersion + " [directory: " + this.dir + ", migrator class: " + this.getMigratorClass());
        }
        MigrationHelper.migrate((String)dataVersion, this.getMigratorClass(), (Object)this.context);
        this.writeDataVersion();
    }

    public boolean needUpgrade() {
        String appVersion;
        if (!this.getVersionFile().exists()) {
            return true;
        }
        String dataVersion = this.readDataVersion();
        return !Objects.equal((Object)dataVersion, (Object)(appVersion = this.getCurrentVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() {
        if (!this.needUpgrade()) {
            return;
        }
        Lock lock = LockUtils.lockForWrite((File)this.dir);
        try {
            this.beforeUpgrade();
            this.doUpgrade();
            this.afterUpgrade();
        }
        finally {
            lock.unlock();
        }
    }

    public String getCurrentVersion() {
        return MigrationHelper.getVersion(this.getMigratorClass());
    }
}

