/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.exception.MalFormedXMLException;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportMetas;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.Pair;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class ReportRelation
extends AbstractTypedXMLObject {
    private static final long serialVersionUID = 1L;
    private String parentReportName;
    private String childReportName;
    private List<Pair<DataColumn, DataColumn>> relatedColumns = new LinkedList<Pair<DataColumn, DataColumn>>();
    private final ReportMetas metas;

    public ReportRelation(ReportMetas metaRepository) {
        this.metas = metaRepository;
    }

    public String getParentReportName() {
        return this.parentReportName;
    }

    public void setParentReportName(String parentReportName) {
        this.parentReportName = parentReportName;
    }

    public String getChildReportName() {
        return this.childReportName;
    }

    public void setChildReportName(String childReportName) {
        this.childReportName = childReportName;
    }

    public List<Pair<DataColumn, DataColumn>> getRelatedColumns() {
        return this.relatedColumns;
    }

    public DataColumn[] getParentColumns() {
        DataColumn[] columns = new DataColumn[this.relatedColumns.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = (DataColumn)this.relatedColumns.get(i).getFirst();
        }
        return columns;
    }

    public DataColumn[] getChildColumns() {
        DataColumn[] columns = new DataColumn[this.relatedColumns.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = (DataColumn)this.relatedColumns.get(i).getSecond();
        }
        return columns;
    }

    public void setRelatedColumns(List<Pair<DataColumn, DataColumn>> relatedColumns) {
        this.relatedColumns = relatedColumns;
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        this.parentReportName = XMLHelper.getString((Node)element, "parent");
        this.childReportName = XMLHelper.getString((Node)element, "child");
        List elements = element.elements("column");
        ReportMetaData parentMeta = this.metas.getMeta(this.parentReportName);
        ReportMetaData childMeta = this.metas.getMeta(this.childReportName);
        if (elements.size() == 0) {
            for (DataColumn column : parentMeta.getPrimaryColumns()) {
                Pair relation = new Pair();
                relation.setFirst((Object)column);
                relation.setSecond((Object)childMeta.getColumn(column.getColumnName()));
                this.relatedColumns.add((Pair<DataColumn, DataColumn>)relation);
            }
        } else {
            for (Element columnElement : elements) {
                String parentName = XMLHelper.getString((Node)columnElement, "parentColumn");
                String childName = XMLHelper.getString((Node)columnElement, "childColumn");
                Pair relation = new Pair();
                if (StringUtils.isEmpty((String)parentName) || StringUtils.isEmpty((String)childName)) {
                    throw new MalFormedXMLException("Either attribute 'parentColumn' or attribute 'childColumn' is not defined.");
                }
                relation.setFirst((Object)parentMeta.getColumn(parentName));
                relation.setSecond((Object)childMeta.getColumn(childName));
                this.relatedColumns.add((Pair<DataColumn, DataColumn>)relation);
            }
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("parent", this.parentReportName);
        element.addAttribute("child", this.childReportName);
        for (Pair<DataColumn, DataColumn> pair : this.relatedColumns) {
            Element columnElement = element.addElement("column");
            columnElement.addAttribute("parentColumn", ((DataColumn)pair.getFirst()).getColumnName());
            columnElement.addAttribute("childColumn", ((DataColumn)pair.getSecond()).getColumnName());
        }
        return element;
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public String getElementName() {
        return "relation";
    }
}

