/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class ReportPluginSetting
implements Validatable {
    private String categoryXML;

    public ReportPluginSetting() {
        this.init();
    }

    @Editable(name="Report Category Setting", order=200, description="The XML specified report category defintions. For details refer to http://wiki.pmease.com")
    @Multiline(value=20)
    @NotEmpty
    public String getCategoryXML() {
        return this.categoryXML;
    }

    public void setCategoryXML(String categoryXML) {
        this.categoryXML = categoryXML;
    }

    public ReportCategory getReportCategory() {
        String xml = this.getCategoryXML();
        if (StringUtils.isEmpty((String)xml)) {
            return null;
        }
        ReportCategory category = this.createReportCategory();
        ReportHelper.fromXML(category, xml);
        return category;
    }

    protected ReportCategory createReportCategory() {
        return new ReportCategory();
    }

    public void validate(Set<String> properties, ErrorContext errorContext) {
        this.getReportCategory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        InputStream input = null;
        try {
            input = this.getClass().getResourceAsStream("setting.xml");
            if (input != null) {
                Document doc = XMLHelper.readXML(input);
                this.categoryXML = doc.asXML();
            }
        }
        finally {
            if (input != null) {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }
}

