/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportRelation;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class ReportMetas
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    private Map<String, ReportMetaData> metas = CaseInsensitiveMap.create(new LinkedHashMap());
    private List<ReportRelation> relations = new ArrayList<ReportRelation>();

    public ReportMetas(ReportCategory category) {
        super(category);
    }

    public ReportMetaData getMeta(String reportName) {
        if (Strings.isNullOrEmpty((String)reportName)) {
            return null;
        }
        return this.metas.get(reportName);
    }

    public ReportRelation getRelation(String parentName, String childName) {
        for (ReportRelation relation : this.relations) {
            if (!relation.getParentReportName().equalsIgnoreCase(parentName) || !relation.getChildReportName().equalsIgnoreCase(childName)) continue;
            return relation;
        }
        return null;
    }

    public ReportRelation[] getRelationsOf(String reportName) {
        ArrayList<ReportRelation> result = new ArrayList<ReportRelation>();
        for (ReportRelation relation : this.relations) {
            if (!relation.getParentReportName().equalsIgnoreCase(reportName) && !relation.getChildReportName().equalsIgnoreCase(reportName)) continue;
            result.add(relation);
        }
        return result.toArray(new ReportRelation[result.size()]);
    }

    public ReportRelation[] getParentRelations(String reportName) {
        ArrayList<ReportRelation> result = new ArrayList<ReportRelation>();
        for (ReportRelation relation : this.relations) {
            if (!relation.getChildReportName().equalsIgnoreCase(reportName)) continue;
            result.add(relation);
        }
        return result.toArray(new ReportRelation[result.size()]);
    }

    public ReportRelation[] getChildRelations(String reportName) {
        ArrayList<ReportRelation> result = new ArrayList<ReportRelation>();
        for (ReportRelation relation : this.relations) {
            if (!relation.getParentReportName().equalsIgnoreCase(reportName)) continue;
            result.add(relation);
        }
        return result.toArray(new ReportRelation[result.size()]);
    }

    public String[] getParentReportNames(String reportName) {
        ReportRelation[] reportRelations;
        HashSet<String> names = new HashSet<String>();
        for (ReportRelation relation : reportRelations = this.getParentRelations(reportName)) {
            names.add(relation.getParentReportName());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getChildReportNames(String reportName) {
        ReportRelation[] reportRelations;
        HashSet<String> names = new HashSet<String>();
        for (ReportRelation relation : reportRelations = this.getChildRelations(reportName)) {
            names.add(relation.getChildReportName());
        }
        return names.toArray(new String[names.size()]);
    }

    public void addMeta(ReportMetaData meta) {
        this.metas.put(meta.getReportName(), meta);
    }

    public void removeMeta(String reportName) {
        this.metas.remove(reportName);
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public void fromXML(Element node) throws ReportException {
        String typeName;
        List nodes = node.selectNodes("./meta");
        for (Element element : nodes) {
            typeName = XMLHelper.getString((Node)element, "type");
            ReportMetaData meta = this.createReportMetaData(typeName);
            meta.fromXML(element);
            this.metas.put(meta.getReportName(), meta);
        }
        nodes = node.selectNodes("./relation");
        for (Element element : nodes) {
            typeName = XMLHelper.getString((Node)element, "type");
            ReportRelation relation = this.createReportRelation(typeName);
            relation.fromXML(element);
            this.relations.add(relation);
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        for (ReportMetaData meta : this.getReportMetas()) {
            element.add(meta.toXML());
        }
        return element;
    }

    public ReportMetaData[] getReportMetas() {
        Collection<ReportMetaData> collection = this.metas.values();
        return collection.toArray(new ReportMetaData[collection.size()]);
    }

    public ReportMetaData[] getReportMetas(ReportGroup catalog) {
        ArrayList<ReportMetaData> result = new ArrayList<ReportMetaData>();
        for (ReportMetaData meta : this.getReportMetas()) {
            if (meta.getGroup() != catalog) continue;
            result.add(meta);
        }
        return result.toArray(new ReportMetaData[result.size()]);
    }

    protected ReportMetaData createReportMetaData(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return new ReportMetaData();
        }
        return TypedObjects.createTypedObject(type, ReportMetaData.class, new Object[0]);
    }

    protected ReportRelation createReportRelation(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return new ReportRelation(this);
        }
        return TypedObjects.createTypedObject(type, ReportRelation.class, this);
    }

    public ReportMetaData[] getMetas() {
        return (ReportMetaData[])Iterables.toArray(this.metas.values(), ReportMetaData.class);
    }

    public List<ReportRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<ReportRelation> relations) {
        this.relations = relations;
    }

    @Override
    public String getElementName() {
        return "metas";
    }
}

