/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.StatisticsReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.UnProcessedReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.UnProcessedReportMeta;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.StatsQuery;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ReportGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.GeneratorRepository;
import com.pmease.quickbuild.plugin.report.engine.metadata.RendererRepository;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportMetas;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportOverviewSetting;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportRelation;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationExecutor;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.unprocessed.UnProcessedRenderer;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportCategory
extends AbstractTypedXMLObject {
    private static Logger LOG = LoggerFactory.getLogger(ReportCategory.class);
    public static ReportCategory NULL_CATEGORY = new EmptyCategory();
    private static final long serialVersionUID = 1L;
    public static final String REPORTS_DIR = "reports/";
    public static final String AGGREGATION_DIR = "aggregations/";
    public static final ReportCategory EMPTY = new ReportCategory();
    @Alias(name="id")
    private String id;
    @Alias(name="name")
    private String name;
    private String version;
    @Alias
    private String initSql;
    @Alias(name="order")
    private int order = 9999;
    private ReportMetas metas;
    protected final GeneratorRepository generatorRepository;
    protected final RendererRepository rendererRepository;
    private ReportOverviewSetting overviewSetting;
    private Map<String, String> expressionTemplates = new HashMap<String, String>();

    public ReportCategory() {
        this.metas = new ReportMetas(this);
        this.generatorRepository = new GeneratorRepository(this);
        this.rendererRepository = new RendererRepository(this);
        this.overviewSetting = new ReportOverviewSetting(this);
        if (this.hasUnProcessedReport()) {
            this.metas.addMeta(new UnProcessedReportMeta());
            this.rendererRepository.addRenderer(new UnProcessedRenderer(this));
        }
        this.version = MigrationHelper.getVersion(this.getMigratorClass());
    }

    public boolean hasUnProcessedReport() {
        return true;
    }

    public ReportMetaData[] getMetas(ReportGroup group) {
        ArrayList result = Lists.newArrayList();
        for (ReportMetaData each : this.metas.getMetas()) {
            if (each.getGroup() != group) continue;
            result.add(each);
        }
        return (ReportMetaData[])Iterables.toArray((Iterable)result, ReportMetaData.class);
    }

    public ReportMetaData getMeta(String reportName) {
        return this.metas.getMeta(reportName);
    }

    public ReportGenerator[] getGenerators(GeneratorStage stage) {
        return this.generatorRepository.getGenerators(stage);
    }

    public AbstractRenderer findRenderer(String tabName, RendererMode mode) {
        for (AbstractRenderer each : this.rendererRepository.getRenderers()) {
            if (!tabName.equalsIgnoreCase(each.getId())) continue;
            return each;
        }
        return null;
    }

    public AbstractRenderer[] getRenderers(RendererMode mode) {
        return this.rendererRepository.getRenderers(mode);
    }

    public AbstractRenderer getRenderer(String id) {
        return this.rendererRepository.getRenderer(id);
    }

    public DataReport createReport(String reportName) {
        ReportMetaData meta = this.metas.getMeta(reportName);
        if (meta == null) {
            throw new ReportException("The report '" + reportName + "' is undefined in category '" + this.name + "'.");
        }
        DataReport report = meta instanceof UnProcessedReportMeta ? new UnProcessedReport() : (meta.getGroup() == ReportGroup.STATISTICS ? new StatisticsReport(meta) : new DataReport(meta));
        report.setVersion(this.getVersion());
        return report;
    }

    @Override
    public void fromXML(Element node) throws ReportException {
        super.fromXML(node);
        try {
            Element element;
            Element templatesElement = (Element)node.selectSingleNode("./templates");
            this.expressionTemplates = new HashMap<String, String>();
            if (templatesElement != null) {
                List elements = templatesElement.selectNodes("./expression");
                for (Element aElement : elements) {
                    String id = XMLHelper.getString((Node)aElement, "id");
                    String template = aElement.getText();
                    this.expressionTemplates.put(id, template);
                }
            }
            if ((element = (Element)node.selectSingleNode("./metas")) != null) {
                this.metas.fromXML(element);
            }
            if ((element = (Element)node.selectSingleNode("./generators")) != null) {
                this.generatorRepository.fromXML(element);
            }
            if ((element = (Element)node.selectSingleNode("./renderers")) != null) {
                this.rendererRepository.fromXML(element);
            }
            if ((element = (Element)node.selectSingleNode("./overview")) != null) {
                this.overviewSetting.fromXML(element);
            }
            if (Strings.isNullOrEmpty((String)this.initSql)) {
                this.initSql = this.getDefaultSql();
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapException((String)("Construct category " + this.name + " failed."), (Throwable)e);
        }
    }

    protected String getDefaultSql() {
        StringBuffer sb = new StringBuffer();
        for (ReportMetaData meta : this.getMetas()) {
            sb.append(meta.getInitSql()).append("\n").append("\n");
        }
        return sb.toString();
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.add(this.metas.toXML());
        element.add(this.generatorRepository.toXML());
        element.add(this.rendererRepository.toXML());
        element.add(this.overviewSetting.toXML());
        return element;
    }

    public void writeVersionFile(File dir) {
        MigrationContext context = new MigrationContext();
        context.setCurrentBean(this);
        context.setDir(dir);
        this.getMigrationExecutor(dir, context).writeDataVersion();
    }

    public CategoryDb getCategoryDb(File dir) {
        return new CategoryDb(this, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowsCount(File dbDir, SqlBuilder query) {
        CategoryDb db = this.getCategoryDb(dbDir);
        if (!db.exists()) {
            return 0L;
        }
        try {
            db.open(DbStore.Mode.READ_ONLY, "ReportCategory::getRowsCount");
            long l = db.queryForLong(query);
            return l;
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowsCount(File dbDir, String reportName, List<Filter> filters) {
        CategoryDb db = this.getCategoryDb(dbDir);
        if (!db.exists()) {
            return 0L;
        }
        try {
            db.open(DbStore.Mode.READ_ONLY, "ReportCategory::getRowsCount");
            SqlBuilder query = SqlBuilder.query().select("COUNT(*)").from(reportName).where(filters);
            long l = db.queryForLong(query);
            return l;
        }
        finally {
            db.close();
        }
    }

    public long getRowsCount(File dbDir, String reportName) {
        return this.getRowsCount(dbDir, reportName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataReport loadReport(File dbDir, SqlBuilder query) {
        long start = System.currentTimeMillis();
        String reportName = query.getTables().get(0);
        DataReport report = this.createReport(reportName);
        CategoryDb db = this.getCategoryDb(dbDir);
        if (!db.exists()) {
            LOG.warn("Report database " + db + " doesn't exist");
            return report;
        }
        try {
            db.open(DbStore.Mode.READ_ONLY, "ReportCategory::loadReport");
            DataReport dataReport = db.loadReport(query, report);
            return dataReport;
        }
        finally {
            db.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("loading report in " + DataTypes.DURATION.asString(System.currentTimeMillis() - start));
            }
        }
    }

    public DataReport loadReport(File dbDir, ReportDataSource rds) {
        return this.loadReport(dbDir, rds.toQuery());
    }

    public DataReport loadReport(File dbDir, String reportName, Filter ... filters) {
        SqlBuilder query = SqlBuilder.query();
        query.select("*").from(reportName).where(filters);
        return this.loadReport(dbDir, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport(File dbDir, DataReport report, MergeFunction<DataRow> rowMerger) {
        CategoryDb db = this.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "ReportCategory::saveReport");
            if (report == null || report.isEmpty()) {
                return;
            }
            db.saveReport(report, rowMerger);
        }
        finally {
            db.close();
        }
    }

    public void saveReport(File dbDir, DataReport report) {
        this.saveReport(dbDir, report, null);
    }

    public void saveReport(CategoryDb db, DataReport report) {
        db.saveReport(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDefaultStats(File dbDir, String reportName, Filter ... filters) {
        CategoryDb db = this.getCategoryDb(dbDir);
        if (!db.exists()) {
            return Collections.emptyMap();
        }
        try {
            db.open(DbStore.Mode.READ_ONLY, "ReportCategory::getDefaultStats");
            Map<String, Object> map = this.getDefaultStats(db, reportName, filters);
            return map;
        }
        finally {
            db.close();
        }
    }

    public Map<String, Object> getDefaultStats(CategoryDb db, String reportName, Filter ... filters) {
        CaseInsensitiveMap<Object> map = CaseInsensitiveMap.create();
        ReportMetaData meta = this.getMeta(reportName);
        List<StatsQuery> queries = meta.getStatsQueries();
        for (StatsQuery each : queries) {
            SqlBuilder query = SqlBuilder.query();
            query.select(each.getSelectColumns()).from(reportName).where(filters);
            if (each.isForEnum()) {
                query.groupby(each.getSelectColumns()[0]);
                List<Object[]> arrays = db.queryForArrayList(query);
                HashMap<String, Object> enums = (HashMap<String, Object>)map.get(each.getSelectColumns()[0]);
                if (enums == null) {
                    enums = new HashMap<String, Object>();
                    map.put(each.getSelectColumns()[0], (Object)enums);
                }
                for (Object[] array : arrays) {
                    enums.put((String)array[0], array[1]);
                }
                continue;
            }
            Map<String, Object> values = db.queryForMap(query);
            map.putAll(values);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeDb(File dbDir) {
        CategoryDb db = this.getCategoryDb(dbDir);
        if (!db.exists()) {
            return;
        }
        try {
            db.open(DbStore.Mode.READ_WRITE, "ReportCategory::optimizeDb");
            db.optimize();
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCategoryDir(File dir) {
        if (!dir.exists()) {
            ReportHelper.getLogger().debug("Creating category dir: " + dir);
            Lock lock = LockUtils.lockForWrite((File)dir);
            try {
                FileUtils.createDir((File)dir);
                this.writeVersionFile(dir);
            }
            finally {
                lock.unlock();
            }
        }
        return dir;
    }

    public File createCategoryDirOfBuild(Build build) {
        File dir = this.getCategoryDirOfBuild(build);
        this.createCategoryDir(dir);
        return dir;
    }

    public File createCategoryDirOfStats(Configuration configuration) {
        return this.createCategoryDir(this.getCategoryDirOfStats(configuration));
    }

    public File createCategoryDirOfAggregation(Configuration configuration) {
        return this.createCategoryDir(this.getCategoryDirOfAggregation(configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCategoryDirOfBuild(Build build) {
        File categoryDir = new File(build.getPublishDir(), REPORTS_DIR + this.getId());
        Lock lock = LockUtils.lockForRead((File)categoryDir);
        try {
            if (categoryDir.exists()) {
                MigrationContext context = new MigrationContext();
                context.setBuild(build);
                context.setDir(categoryDir);
                this.upgrade(categoryDir, context);
            }
            File file = categoryDir;
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCategoryDirOfStats(Configuration configuration) {
        File categoryDir = new File(configuration.getPublishDir(), REPORTS_DIR + this.getId());
        Lock lock = LockUtils.lockForRead((File)categoryDir);
        try {
            if (categoryDir.exists()) {
                MigrationContext context = new MigrationContext();
                context.setConfiguration(configuration);
                context.setDir(categoryDir);
                this.upgrade(categoryDir, context);
            }
            File file = categoryDir;
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCategoryDirOfAggregation(Configuration configuration) {
        File categoryDir;
        Preconditions.checkNotNull((Object)configuration);
        Context.push((Configuration)configuration);
        try {
            categoryDir = new File(configuration.getPublishDir(), AGGREGATION_DIR + this.getId());
        }
        finally {
            Context.pop();
        }
        Lock lock = LockUtils.lockForRead((File)categoryDir);
        try {
            if (categoryDir.exists()) {
                MigrationContext context = new MigrationContext();
                context.setConfiguration(configuration);
                context.setDir(categoryDir);
                this.upgrade(categoryDir, context);
            }
            File file = categoryDir;
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    public String getCategoryRelativeDir() {
        return REPORTS_DIR + this.getId();
    }

    public String getReportSetRelativeDir(String reportset) {
        return this.getCategoryRelativeDir() + "/" + reportset;
    }

    public String[] getReportSetsOfBuild(Build build) {
        if (build == null) {
            return new String[0];
        }
        File categoryDir = this.getCategoryDirOfBuild(build);
        return this.getReportSets(categoryDir);
    }

    public String[] getReportSetsOfStats(Configuration configuration) {
        File categoryDir = this.getCategoryDirOfStats(configuration);
        return this.getReportSets(categoryDir);
    }

    public String[] getReportSetsOfAggregation(Configuration configuration) {
        File categoryDir = this.getCategoryDirOfAggregation(configuration);
        return this.getReportSets(categoryDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteReportDir(File reportDir) {
        Lock lock = LockUtils.lockForWrite((File)reportDir);
        try {
            FileUtils.deleteDir((File)reportDir);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReportSetOfBuild(Build build, String reportset) {
        Lock lock = LockUtils.lockForWrite((File)this.getCategoryDirOfBuild(build));
        try {
            File reportDir = this.getReportDirOfBuild(build, reportset);
            if (!reportDir.exists()) {
                return;
            }
            FileUtils.deleteDir((File)reportDir);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllReportSetsOfBuild(Build build) {
        File categoryDir = this.getCategoryDirOfBuild(build);
        Lock lock = LockUtils.lockForWrite((File)categoryDir);
        try {
            if (!categoryDir.exists()) {
                return;
            }
            FileUtils.deleteDir((File)categoryDir);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReportSetOfStats(Configuration configuration, String reportset) {
        Lock lock = LockUtils.lockForWrite((File)this.getCategoryDirOfStats(configuration));
        try {
            File reportDir = this.getReportDirOfStats(configuration, reportset);
            if (!reportDir.exists()) {
                return;
            }
            this.deleteReportDir(reportDir);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllReportSetsOfStats(Configuration configuration) {
        File categoryDir = this.getCategoryDirOfStats(configuration);
        Lock lock = LockUtils.lockForWrite((File)categoryDir);
        try {
            if (!categoryDir.exists()) {
                return;
            }
            FileUtils.deleteDir((File)categoryDir);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReportSetOfAggregation(Configuration configuration, String reportset) {
        Lock lock = LockUtils.lockForWrite((File)this.getCategoryDirOfAggregation(configuration));
        try {
            File reportDir = this.getReportDirOfAggregation(configuration, reportset);
            if (!reportDir.exists()) {
                return;
            }
            FileUtils.deleteDir((File)reportDir);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllReportSetsOfAggregation(Configuration configuration) {
        File categoryDir = this.getCategoryDirOfAggregation(configuration);
        Lock lock = LockUtils.lockForWrite((File)categoryDir);
        try {
            if (!categoryDir.exists()) {
                return;
            }
            FileUtils.deleteDir((File)categoryDir);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean isReportDir(File dir) {
        return dir.isDirectory() && (FileUtils.containsFileWithSuffix((File)dir, (String)".xml") || FileUtils.containsFileWithSuffix((File)dir, (String)".h2.db"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getReportSets(File categoryDir) {
        Lock r = LockUtils.lockForRead((File)categoryDir);
        try {
            if (categoryDir == null || !categoryDir.exists()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            File[] dirs = categoryDir.listFiles();
            ArrayList<String> reportsets = new ArrayList<String>();
            for (File dir : dirs) {
                if (!this.isReportDir(dir)) continue;
                reportsets.add(dir.getName());
            }
            Collections.sort(reportsets, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if ("DEFAULT".equals(o1)) {
                        return -1;
                    }
                    if ("DEFAULT".equals(o2)) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            String[] stringArray = reportsets.toArray(new String[0]);
            return stringArray;
        }
        finally {
            if (r != null) {
                r.unlock();
            }
        }
    }

    public File getReportDirOfBuild(Build build, String reportset) {
        File dir = this.getCategoryDirOfBuild(build);
        return reportset == null ? new File(dir, "DEFAULT") : new File(dir, reportset);
    }

    public File getReportDirOfStats(Configuration configuration, String reportset) {
        File dir = this.getCategoryDirOfStats(configuration);
        return reportset == null ? new File(dir, "DEFAULT") : new File(dir, reportset);
    }

    public File getReportDirOfAggregation(Configuration configuration, String aggregationName) {
        File dir = this.getCategoryDirOfAggregation(configuration);
        return new File(dir, aggregationName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ReportMetaData[] getMetas() {
        return this.metas.getMetas();
    }

    public void addMeta(ReportMetaData meta) {
        this.metas.addMeta(meta);
    }

    public void removeMeta(String reportName) {
        this.metas.removeMeta(reportName);
    }

    public ReportRelation getRelation(String parentName, String childName) {
        return this.metas.getRelation(parentName, childName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RendererRepository getRendererRepository() {
        return this.rendererRepository;
    }

    public void addRenderer(AbstractRenderer r) {
        this.rendererRepository.addRenderer(r);
    }

    public void removeRenderer(String id) {
        this.rendererRepository.remvoeRenderer(id);
    }

    public GeneratorRepository getGeneratorRepository() {
        return this.generatorRepository;
    }

    public void addGenerator(AbstractGenerator g) {
        this.generatorRepository.addGenerator(g);
    }

    public Map<String, String> getExpressionTemplates() {
        return this.expressionTemplates;
    }

    public void setExpressionTemplates(Map<String, String> expressionTemplates) {
        this.expressionTemplates = expressionTemplates;
    }

    public String getExpressionTemplate(String key) {
        return this.expressionTemplates.get(key);
    }

    public ReportOverviewSetting getOverviewSetting() {
        return this.overviewSetting;
    }

    public void setOverviewSetting(ReportOverviewSetting overviewSetting) {
        this.overviewSetting = overviewSetting;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public void setInitSql(String sql) {
        this.initSql = sql;
    }

    public void upgrade(File categoryDir, MigrationContext context) {
        this.getMigrationExecutor(categoryDir, context).upgrade();
    }

    protected MigrationExecutor getMigrationExecutor(File dir, MigrationContext context) {
        context.setCurrentBean(this);
        context.setCategory(this);
        return new MigrationExecutor(dir, context){

            @Override
            public Class<?> getMigratorClass() {
                return ReportCategory.this.getMigratorClass();
            }

            @Override
            protected String getVersionFileName() {
                return "category.version";
            }
        };
    }

    public Class<? extends ReportCategoryMigrator> getMigratorClass() {
        return ReportCategoryMigrator.class;
    }

    @Override
    public String getElementName() {
        return "category";
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ReportCategory)) {
            return false;
        }
        ReportCategory rhs = (ReportCategory)other;
        return Objects.equal((Object)rhs.getId(), (Object)this.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    public String toString() {
        return this.getName();
    }

    static class EmptyCategory
    extends ReportCategory {
        private static final long serialVersionUID = 1L;

        public EmptyCategory() {
            this.setName("EmptyCategory");
        }

        @Override
        public String[] getReportSetsOfBuild(Build build) {
            return new String[0];
        }

        @Override
        public String[] getReportSetsOfStats(Configuration configuration) {
            return new String[0];
        }

        @Override
        public String[] getReportSetsOfAggregation(Configuration configuration) {
            return new String[0];
        }
    }
}

