/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.dom4j.Element;

public class RendererRepository
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    private Map<String, AbstractRenderer> renderers = CaseInsensitiveMap.create();

    public RendererRepository(ReportCategory category) {
        super(category);
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public void fromXML(Element node) {
        List nodes = node.elements("renderer");
        for (Element each : nodes) {
            AbstractRenderer renderer = TypedObjects.createTypedObject(each, AbstractRenderer.class, null, this.category);
            renderer.fromXML(each);
            this.addRenderer(renderer);
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        for (AbstractRenderer renderer : this.getRenderers()) {
            element.add(renderer.toXML());
        }
        return element;
    }

    public AbstractRenderer[] getRenderers() {
        ArrayList<AbstractRenderer> list = new ArrayList<AbstractRenderer>(this.renderers.values());
        Collections.sort(list, new Comparator<AbstractRenderer>(){

            @Override
            public int compare(AbstractRenderer o1, AbstractRenderer o2) {
                return ComparableComparator.getInstance().compare((Object)o1.getOrder(), (Object)o2.getOrder());
            }
        });
        return list.toArray(new AbstractRenderer[list.size()]);
    }

    public AbstractRenderer[] getRenderers(RendererMode mode) {
        ArrayList<AbstractRenderer> renderers = new ArrayList<AbstractRenderer>();
        for (AbstractRenderer renderer : this.renderers.values()) {
            if (renderer.getMode() != mode) continue;
            renderers.add(renderer);
        }
        Collections.sort(renderers, new Comparator<AbstractRenderer>(){

            @Override
            public int compare(AbstractRenderer o1, AbstractRenderer o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        return renderers.toArray(new AbstractRenderer[renderers.size()]);
    }

    public AbstractRenderer getRenderer(String id) {
        AbstractRenderer renderer = this.renderers.get(id);
        if (renderer == null) {
            throw new ReportException("Renderer '" + id + "' is not defined.");
        }
        return renderer;
    }

    public void addRenderer(AbstractRenderer renderer) {
        Preconditions.checkNotNull((Object)renderer.getId(), (Object)"Renderer id must be defined.");
        this.renderers.put(renderer.getId(), renderer);
    }

    public void remvoeRenderer(String id) {
        this.renderers.remove(id);
    }

    public void setRenderers(Map<String, AbstractRenderer> renderers) {
        this.renderers = renderers;
    }

    @Override
    public String getElementName() {
        return "renderers";
    }
}

