/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.exception.MalFormedXMLException;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.DefaultGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class GeneratorRepository
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    private List<AbstractGenerator> generators = new LinkedList<AbstractGenerator>();

    public GeneratorRepository(ReportCategory category) {
        super(category);
    }

    public AbstractGenerator[] getGenerators(GeneratorStage stage) {
        ArrayList<AbstractGenerator> result = new ArrayList<AbstractGenerator>();
        for (AbstractGenerator generator : this.generators) {
            if (generator.getStage() != stage) continue;
            result.add(generator);
        }
        return result.toArray(new AbstractGenerator[result.size()]);
    }

    public AbstractGenerator getGenerator(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        for (AbstractGenerator generator : this.generators) {
            if (!generator.getId().equalsIgnoreCase(id)) continue;
            return generator;
        }
        return null;
    }

    public void addGenerator(AbstractGenerator generator) {
        this.generators.add(generator);
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public void fromXML(Element node) throws ReportException {
        List elements = node.elements();
        this.generators.clear();
        for (Element element : elements) {
            this.generators.add(this.createGenerator(element));
        }
    }

    protected AbstractGenerator createGenerator(Element element) {
        if (element == null) {
            return null;
        }
        AbstractGenerator generator = TypedObjects.createTypedObject(element, AbstractGenerator.class, new DefaultGenerator(this.category), this.category);
        if (generator == null) {
            throw new MalFormedXMLException("Unable to create generator.");
        }
        generator.fromXML(element);
        return generator;
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        for (AbstractGenerator generator : this.generators) {
            element.add(((AbstractTypedXMLObject)generator).toXML());
        }
        return element;
    }

    public List<AbstractGenerator> getGenerators() {
        return this.generators;
    }

    public void setGenerators(List<AbstractGenerator> generators) {
        this.generators = generators;
    }

    public void setGenerators(AbstractGenerator[] generators) {
        this.generators = Lists.newArrayList((Object[])generators);
    }

    @Override
    public String getElementName() {
        return "generators";
    }
}

