/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DataReportMapper;
import com.pmease.quickbuild.plugin.report.engine.datastore.DataRowMapper;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CategoryDb
extends DbStore {
    private final ReportCategory category;

    public CategoryDb(ReportCategory category, File dbDir) {
        super(dbDir);
        this.category = category;
    }

    @Override
    protected String getDbName() {
        return this.category.getId();
    }

    @Override
    protected void createDb() {
        String sql = this.category.getInitSql();
        Iterator it = Splitter.on((String)";").omitEmptyStrings().trimResults().split((CharSequence)sql).iterator();
        if (!it.hasNext()) {
            throw new DatabaseException("No init sql script found for category " + this.category);
        }
        try {
            this.update("SET COMPRESS_LOB DEFLATE");
            while (it.hasNext()) {
                this.update((String)it.next());
            }
        }
        catch (Exception e) {
            FileUtils.deleteFile((File)this.getDbFile());
            throw new DatabaseException("Creating database " + this + " failed!", e);
        }
    }

    public DataReport loadReport(SqlBuilder query) {
        String reportName = query.getTables().get(0);
        DataReport report = this.category.createReport(reportName);
        return this.loadReport(query, report);
    }

    public DataReport loadReport(SqlBuilder query, DataReport report) {
        if (!this.exists()) {
            return report;
        }
        return this.query(query, new DataReportMapper(report));
    }

    public DataReport loadReport(String reportName, Filter ... filters) {
        DataReport report = this.category.createReport(reportName);
        if (!this.exists()) {
            return report;
        }
        SqlBuilder sb = SqlBuilder.query().select("*").from(reportName).where(filters);
        return this.query(sb, new DataReportMapper(report));
    }

    public DataReport loadReport(String reportName, String where) {
        return this.loadReport(reportName, Restrictions.directSql(where));
    }

    public DataRow findRow(String reportName, Filter ... filters) {
        return this.findRow(reportName, (String[])null, filters);
    }

    public DataRow findRow(String reportName, String[] selectColumns, Filter ... filters) {
        DataReport report = this.category.createReport(reportName);
        DataRow row = new DataRow(report);
        if (!this.exists()) {
            return null;
        }
        SqlBuilder sb = SqlBuilder.query();
        if (selectColumns == null || selectColumns.length == 0) {
            sb.select("*");
        } else {
            sb.select(selectColumns);
        }
        sb.from(reportName).where(filters);
        return this.query(sb, new DataRowMapper(row));
    }

    public DataRow findRow(Long id, String reportName) {
        DataReport report = this.category.createReport(reportName);
        DataRow row = new DataRow(report);
        SqlBuilder sb = SqlBuilder.query().select("*").from(reportName).where(Restrictions.idEq(id));
        return this.query(sb, new DataRowMapper(row));
    }

    public DataRow findRow(DataRow example) {
        DataRow row = new DataRow(example.getReport());
        ReportMetaData meta = example.getReport().getMeta();
        SqlBuilder sb = SqlBuilder.query().select("*").from(meta.getReportName());
        ArrayList filters = Lists.newArrayList();
        for (DataColumn each : meta.getPrimaryColumns()) {
            String columnName = each.getColumnName();
            filters.add(Restrictions.eq(columnName, each.getDataType().asDbObject(example.getValue(columnName))));
        }
        sb.where((Filter[])Iterables.toArray((Iterable)filters, Filter.class));
        return this.query(sb, new DataRowMapper(row));
    }

    private void insertRow(DataRow row) {
        SqlBuilder sb = SqlBuilder.insert(row.getReport().getReportName());
        DataColumn[] columns = row.getReport().getMeta().getColumns();
        ArrayList values = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        for (int i = 0; i < columns.length; ++i) {
            DataType dataType = columns[i].getDataType();
            if (!columns[i].isUpdatable()) continue;
            values.add(dataType.asDbObject(row.getNullableValue(columns[i].getColumnName())));
            names.add(columns[i].getColumnName());
        }
        sb.values((String[])Iterables.toArray((Iterable)names, String.class), Iterables.toArray((Iterable)values, Object.class));
        this.update(sb);
    }

    private void updateRow(DataRow row) {
        SqlBuilder sb = SqlBuilder.update(row.getReport().getReportName());
        Long id = row.getId();
        if (id == null) {
            throw new DatabaseException("ID should be specifed when updating row.");
        }
        DataColumn[] columns = row.getReport().getMeta().getColumns();
        ArrayList values = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        for (int i = 0; i < columns.length; ++i) {
            DataType dataType = columns[i].getDataType();
            if (!columns[i].isUpdatable()) continue;
            values.add(dataType.asDbObject(row.getNullableValue(columns[i].getColumnName())));
            names.add(columns[i].getColumnName());
        }
        sb.values((String[])Iterables.toArray((Iterable)names, String.class), Iterables.toArray((Iterable)values, Object.class));
        sb.where(Restrictions.idEq(id));
        this.update(sb);
    }

    static Map<String, Object> rowToMap(DataRow row) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (DataColumn each : row.getReport().getMeta().getColumns()) {
            map.put(each.getColumnName(), row.getValue(each.getColumnName()));
        }
        return map;
    }

    public DataRow persistRow(DataRow row) {
        return this.persistRow(row, null);
    }

    public DataRow persistRow(DataRow row, MergeFunction<DataRow> rowMerger) {
        if (rowMerger == null) {
            this.insertRow(row);
        } else {
            DataRow found = this.findRow(row);
            if (found == null) {
                this.insertRow(row);
            } else {
                row.setId(found.getId());
                DataRow merged = rowMerger.process(found, row);
                if (merged != found) {
                    this.updateRow(merged);
                }
                row = merged;
            }
        }
        return row;
    }

    public void saveReport(DataReport report) {
        this.saveReport(report, null);
    }

    public void saveReport(DataReport report, MergeFunction<DataRow> rowMerger) {
        try {
            for (DataRow each : report.getRows()) {
                this.persistRow(each, rowMerger);
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Saving report '" + this.category.getName() + ":" + report.getReportName() + "' failed!", e);
        }
    }

    public void optimize() {
        try {
            this.update("ANALYZE SAMPLE_SIZE 0");
        }
        catch (Exception e) {
            throw new DatabaseException("Optimize database " + this.getDbDir() + " failed! ", e);
        }
    }

    @Override
    protected File getLockDir() {
        File dbDir = this.getDbDir();
        File categoryDir = dbDir.getParentFile();
        Preconditions.checkNotNull((Object)categoryDir, (Object)("It seems directory: " + dbDir + " is not a valid category database directory."));
        return categoryDir;
    }

    public ReportCategory getCategory() {
        return this.category;
    }
}

