/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.xpath;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractCollectionType;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class XPathRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;
    private String pattern;
    private String parentPath;
    private String expression;

    public XPathRule(ReportCategory category) {
        super(category);
    }

    @Override
    protected void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        Element element = context.getCurrentElement();
        DataType dataType = destRow.getReport().getDataType(this.getColumnName());
        String xpath = this.getValueExpression();
        if (dataType.isCollectionType()) {
            List<Object> objects = new ArrayList();
            DataColumn column = destRow.getReport().getColumn(this.getColumnName());
            if (StringUtils.isEmpty((String)this.parentPath)) {
                String stringValue = element.valueOf(xpath);
                if (StringUtils.isEmpty((String)stringValue)) {
                    return;
                }
                objects = (List)dataType.fromString(stringValue, this.pattern, context.getLocale());
            } else {
                List elements = element.selectNodes(this.parentPath);
                ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
                DataType itemType = ((AbstractCollectionType)column.getDataType()).getItemType();
                for (Node node : elements) {
                    Object value;
                    if (!StringUtils.isEmpty((String)this.expression)) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        value = itemType.getDefaultValue();
                        map.put("value", value);
                        map.put("node", node);
                        Object result = em.evaluate(this.expression, map);
                        if (result == null) continue;
                        objects.add(result);
                        continue;
                    }
                    String str = node.valueOf(xpath);
                    if (StringUtils.isEmpty((String)str) || (value = itemType.fromString(str = str.trim(), null, context.getLocale())) == null) continue;
                    objects.add(value);
                }
            }
            if (objects.size() == 0) {
                return;
            }
            List value = (List)destRow.getValue(this.getColumnName());
            value.addAll(objects);
            destRow.setValue(this.getColumnName(), (Object)value);
        } else {
            String str = element.valueOf(this.getValueExpression());
            if (str != null) {
                str = str.trim();
            }
            Object obj = dataType.fromString(str, this.pattern, context.getLocale());
            destRow.setValue(this.getColumnName(), obj);
        }
    }

    @Override
    public String getType() {
        return "XPATH";
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        super.fromXML(element);
        this.parentPath = XMLHelper.getString((Node)element, "select");
        this.pattern = XMLHelper.getString((Node)element, "pattern");
        if (StringUtils.isEmpty((String)this.getValueExpression())) {
            this.setValueExpression("./@" + this.getColumnName());
        }
        this.expression = XMLHelper.getString((Node)element, "expression");
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("select", this.parentPath);
        element.addAttribute("pattern", this.pattern);
        return element;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }
}

