/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.xpath;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.reader.XMLResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathParamRule;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XPathProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 1L;
    private String rootXPath;
    private List<AbstractRule> paramRules = new ArrayList<AbstractRule>();

    public XPathProcessor(ReportCategory category) {
        super(category);
    }

    protected XMLResourceReader createDefaultReader() {
        return new XMLResourceReader();
    }

    @Override
    protected AbstractRule createDefaultRule() {
        return new XPathRule(this.category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processResource(GeneratorResource resource) {
        ResourceReader<?> reader = this.createReader();
        if (reader == null) {
            return;
        }
        GeneratorContext context = this.getContext();
        context.setResource(resource);
        try {
            Document doc;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Start opening original document");
            }
            if ((doc = (Document)reader.read()) == null) {
                return;
            }
            if (this.getParamRules().size() > 0) {
                Element rootElement = doc.getRootElement();
                HashMap<String, Object> params = new HashMap<String, Object>();
                context.setParams(params);
                context.setCurrentElement(rootElement);
                for (AbstractRule rule : this.getParamRules()) {
                    this.executeRule(rule);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("End opening original document");
            }
            List<Element> elements = null;
            elements = "/".equals(this.getRootXPath()) || StringUtils.isEmpty((String)this.getRootXPath()) ? Arrays.asList(doc.getRootElement()) : doc.selectNodes(this.getRootXPath());
            DataReport report = context.getDestReport();
            for (Element element : elements) {
                context.setCurrentElement(element);
                DataRow row = report.addRow();
                context.setSourceRow(row);
                context.setDestRow(row);
                this.processCurrentElement();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Finished processing nodes");
            }
        }
        finally {
            reader.close();
        }
    }

    protected void processCurrentElement() {
        for (AbstractRule rule : this.getRules()) {
            this.executeRule(rule);
        }
    }

    @Override
    public String getType() {
        return "XPATH";
    }

    public String getRootXPath() {
        return this.rootXPath;
    }

    public void setRootXPath(String rootXPath) {
        this.rootXPath = rootXPath;
    }

    public List<AbstractRule> getParamRules() {
        return this.paramRules;
    }

    public void setParamRules(List<AbstractRule> paramRules) {
        this.paramRules = paramRules;
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        super.fromXML(element);
        this.rootXPath = XMLHelper.getString((Node)element, "root");
        List elements = element.selectNodes("./param");
        this.paramRules.clear();
        for (Element ruleElement : elements) {
            XPathParamRule rule = new XPathParamRule(this.category);
            ((AbstractTypedXMLObject)rule).fromXML(ruleElement);
            this.paramRules.add(rule);
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("root", this.rootXPath);
        return element;
    }
}

