/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.xpath;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class XPathParamRule
extends XPathRule {
    private static final long serialVersionUID = 1L;
    private String paramName;
    private DataType dataType;
    private DataType itemType;

    public XPathParamRule(ReportCategory category) {
        super(category);
    }

    @Override
    public void doExecute() {
        GeneratorContext context = this.getContext();
        Element element = context.getCurrentElement();
        if (element == null) {
            return;
        }
        String xpath = this.getValueExpression();
        Map<String, Object> map = context.getParams();
        if (map == null) {
            map = new HashMap<String, Object>();
            context.setParams(map);
        }
        if (this.dataType.isCollectionType()) {
            List<Object> objects = Lists.newArrayList();
            map.put(this.paramName, objects);
            if (StringUtils.isEmpty((String)this.getParentPath())) {
                String stringValue = element.valueOf(xpath);
                if (StringUtils.isEmpty((String)stringValue)) {
                    return;
                }
                objects = DataTypes.LIST.fromString(stringValue, this.getPattern(), null, context.getLocale());
            } else {
                List elements = element.selectNodes(this.getParentPath());
                for (Node node : elements) {
                    Object value;
                    String str = node.valueOf(xpath);
                    if (StringUtils.isEmpty((String)str) || (value = this.itemType.fromString(str = str.trim(), null, context.getLocale())) == null) continue;
                    objects.add(value);
                }
            }
        } else {
            String str = element.valueOf(xpath);
            Object value = this.dataType.fromString(str, this.getPattern(), context.getLocale());
            map.put(this.paramName, value);
        }
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        super.fromXML(element);
        this.paramName = XMLHelper.getString((Node)element, "name");
        String type = XMLHelper.getString((Node)element, "dataType");
        this.dataType = !StringUtils.isEmpty((String)type) ? DataTypes.getDataType(type) : DataTypes.STRING;
        type = XMLHelper.getString((Node)element, "itemType");
        this.itemType = !StringUtils.isEmpty((String)type) ? DataTypes.getDataType(type) : DataTypes.STRING;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DataType getItemType() {
        return this.itemType;
    }

    public void setItemType(DataType itemType) {
        this.itemType = itemType;
    }

    @Override
    public String toString() {
        return "Param Rule: [" + this.paramName + ", " + this.getValueExpression() + "]";
    }
}

