/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.reader;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.io.File;

public class ReportResourceReader
implements ResourceReader<DataReport> {
    @Override
    public void close() {
    }

    @Override
    public DataReport read() {
        GeneratorResource resource = this.getResource();
        ReportCategory category = this.getCategory();
        if (resource == null || !resource.exists()) {
            return null;
        }
        Object passthroughObject = resource.getPassthroughObject();
        if (passthroughObject != null && passthroughObject instanceof DataReport) {
            return (DataReport)passthroughObject;
        }
        ReportDataSource rds = resource.getReportResource();
        if (rds == null) {
            throw new ReportException("Report resource is not defined.");
        }
        File dir = resource.getFile();
        return category.loadReport(dir, rds);
    }

    @Override
    public String getType() {
        return "REPORT";
    }

    public GeneratorResource getResource() {
        return (GeneratorResource)GeneratorContext.getContext().get("generator.context.resource");
    }

    public ReportCategory getCategory() {
        return GeneratorContext.getContext().getReportCategory();
    }
}

