/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.persistent;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.generator.DefaultGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.io.File;

public class PersistBuildReportGenerator
extends DefaultGenerator {
    private static final long serialVersionUID = 1L;

    @Override
    public String getType() {
        return "PERSIST_BUILD_REPORTS";
    }

    public PersistBuildReportGenerator(ReportCategory category) {
        super(category);
        this.setStage(GeneratorStage.STATISTICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() {
        ReportCategory category = this.getCategory();
        GeneratorContext context = this.getContext();
        Build build = context.getCurrentBuild();
        File sourceDir = category.getReportDirOfBuild(build, "DEFAULT");
        File workingDir = category.getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        ReportMetaData[] metas = category.getMetas(ReportGroup.PERSISTENCE);
        CategoryDb db = category.getCategoryDb(workingDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "PersistBuildReportGenerator::generate");
            for (ReportMetaData each : metas) {
                SqlBuilder sql = SqlBuilder.deleteFrom(each.getReportName()).where(Restrictions.eq("buildId", build.getId()));
                db.update(sql);
            }
        }
        finally {
            db.close();
        }
        for (ReportMetaData each : metas) {
            DataReport report = category.loadReport(sourceDir, each.getReportName(), new Filter[0]);
            category.saveReport(workingDir, report);
        }
    }
}

