/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.history;

import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.comparison.ComparisonProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportRelation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HistoryProcessor
extends ComparisonProcessor {
    private static final long serialVersionUID = 1L;

    public HistoryProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    public String getType() {
        return "HISTORY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        if (sourceReport == null) {
            return;
        }
        DataReport destReport = context.getDestReport();
        ReportMetaData meta = destReport.getMeta();
        ReportCategory category = context.getReportCategory();
        ReportRelation relation = category.getRelation(destReport.getReportName(), sourceReport.getReportName());
        DataColumn[] compareColumns = relation != null ? relation.getParentColumns() : meta.getPrimaryColumns();
        CategoryDb db = category.getCategoryDb(context.getWorkingDir());
        try {
            db.open(DbStore.Mode.READ_WRITE, "HistoryProcessor::processResource");
            destReport = db.loadReport(destReport.getReportName(), new Filter[0]);
            List<AbstractRule> rules = this.getRules(meta, sourceReport.getMeta());
            Map<String, Integer> destIndex = destReport.getRowIndexMap(compareColumns);
            HashSet keys = Sets.newHashSet();
            for (DataRow sourceRow : sourceReport.getRows()) {
                String key = sourceRow.getRowKeyString(compareColumns);
                Integer i = destIndex.get(key);
                DataRow destRow = i == null ? destReport.addRow() : destReport.getRow(i);
                context.setSourceRow(sourceRow);
                context.setDestRow(destRow);
                for (AbstractRule rule : rules) {
                    this.executeRule(rule);
                }
                String rowKey = destRow.getRowKeyString();
                if (i == null) {
                    destIndex.put(destRow.getRowKeyString(compareColumns), destReport.getRowsCount() - 1);
                }
                keys.add(rowKey);
            }
            db.update("TRUNCATE TABLE " + destReport.getMeta().getReportName());
            db.saveReport(destReport);
        }
        finally {
            db.close();
        }
    }
}

