/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.group;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportRelation;
import java.util.List;
import java.util.Map;

public class GroupProcessor
extends ExpressionProcessor {
    private static final long serialVersionUID = 1L;

    public GroupProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    protected void processResource(GeneratorResource resource) {
        ReportRelation relation;
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        if (sourceReport == null) {
            return;
        }
        DataReport destReport = context.getDestReport();
        DataColumn[] compareColumns = null;
        ReportMetaData meta = destReport.getMeta();
        ReportCategory category = context.getReportCategory();
        compareColumns = category != null ? ((relation = category.getRelation(meta.getReportName(), sourceReport.getReportName())) != null ? relation.getParentColumns() : meta.getPrimaryColumns()) : meta.getPrimaryColumns();
        List<AbstractRule> rules = this.getRules(meta, sourceReport.getMeta());
        Map<String, Integer> destIndexes = destReport.getRowIndexMap(compareColumns);
        for (DataRow row : sourceReport.getRows()) {
            String key = row.getRowKeyString(compareColumns);
            Integer i = destIndexes.get(key);
            DataRow destRow = null;
            destRow = i != null ? destReport.getRow(i) : destReport.addRow();
            context.setSourceRow(row);
            context.setDestRow(destRow);
            for (AbstractRule rule : rules) {
                this.executeRule(rule);
            }
            if (i != null) continue;
            destIndexes.put(key, destReport.getRowsCount() - 1);
        }
    }

    @Override
    public String getType() {
        return "GROUP";
    }
}

