/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.expression;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ExpressionRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;

    public ExpressionRule(ReportCategory category) {
        super(category);
    }

    public ExpressionRule(ReportCategory category, String columnName, String expression) {
        super(category, columnName, expression);
    }

    @Override
    protected void doExecute() {
        GeneratorContext context = this.getContext();
        Object value = this.evalValue();
        String columnName = this.getColumnName();
        DataRow destRow = context.getDestRow();
        if (destRow == null) {
            DataRow sourceRow = context.getSourceRow();
            destRow = context.getDestReport().addRow(sourceRow);
            context.setDestRow(destRow);
        }
        destRow.setValue(columnName, value);
    }

    protected Object evalValue() {
        Object value = null;
        if (StringUtils.isEmpty((String)this.getValueExpression())) {
            value = this.getDefaultValue(this.getColumnName());
        } else {
            Map<String, Object> expressionContext = this.prepareExpressionContext();
            value = ((ScriptEngine)Quickbuild.getInstance(ScriptEngine.class)).evaluate(this.getValueExpression(), expressionContext);
        }
        return value;
    }

    @Override
    public String getType() {
        return "EXPRESSION";
    }

    protected Object getDefaultValue(String name) {
        GeneratorContext context = this.getContext();
        DataRow sourceRow = context.getSourceRow();
        return sourceRow.getValue(name);
    }
}

