/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.expression;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractDataReportProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.util.ArrayList;
import java.util.List;

public class ExpressionProcessor
extends AbstractDataReportProcessor {
    private static final long serialVersionUID = 1L;

    public ExpressionProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    protected AbstractRule createDefaultRule() {
        return new ExpressionRule(this.category);
    }

    @Override
    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        DataReport destReport = context.getDestReport();
        if (sourceReport == null) {
            return;
        }
        int size = Math.max(sourceReport.getRowsCount(), destReport.getRowsCount());
        for (int i = 0; i < size; ++i) {
            DataRow sourceRow = null;
            DataRow destRow = null;
            if (i < sourceReport.getRowsCount()) {
                sourceRow = sourceReport.getRow(i);
            }
            destRow = i < destReport.getRowsCount() ? destReport.getRow(i) : destReport.addRow();
            context.setDestRow(destRow);
            context.setSourceRow(sourceRow);
            for (AbstractRule rule : this.getRules()) {
                this.executeRule(rule);
            }
        }
    }

    protected List<AbstractRule> getRules(ReportMetaData destMeta, ReportMetaData sourceMeta) {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        List<AbstractRule> nonCalcColumnRules = this.getNonCalcColumnRules(destMeta, sourceMeta);
        if (nonCalcColumnRules.size() > 0) {
            rules.addAll(nonCalcColumnRules);
        }
        rules.addAll(super.getRules());
        return rules;
    }

    private List<AbstractRule> getNonCalcColumnRules(ReportMetaData destMeta, ReportMetaData sourceMeta) {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        for (DataColumn column : this.getNonCalcColumns(destMeta)) {
            if (column.getColumnName().equalsIgnoreCase("id") || destMeta != sourceMeta && !sourceMeta.hasColumn(column.getColumnName())) continue;
            rules.add(this.createColumnRule(column));
        }
        return rules;
    }

    protected AbstractRule createColumnRule(DataColumn column) {
        ExpressionRule rule = new ExpressionRule(this.category);
        String columnName = column.getColumnName();
        rule.setColumnName(columnName);
        if (column.getColumnName().equals("buildId")) {
            rule.setValueExpression("build.getId()");
        } else if (column.getDataType().isNumericType()) {
            rule.setValueExpression("current." + columnName + " + source." + columnName);
        } else if (column.getDataType() instanceof BooleanType) {
            rule.setValueExpression("source." + columnName + " && current." + columnName);
        } else if (column.getDataType().isCollectionType()) {
            rule.setValueExpression("current." + columnName + ".addAll(source." + columnName + "); return current." + columnName + ";");
        } else {
            rule.setValueExpression("source." + columnName);
        }
        return rule;
    }

    @Override
    public String getType() {
        return "EXPRESSION";
    }
}

