/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.duplicate;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.duplicate.DuplicatePolicy;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class DuplicateProcessor
extends ExpressionProcessor {
    private static final long serialVersionUID = 1L;
    private DuplicatePolicy strategy;

    public DuplicateProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        super.fromXML(element);
        String str = XMLHelper.getString((Node)element, "duplicatePolicy");
        this.strategy = StringUtils.isEmpty((String)str) ? DuplicatePolicy.DISCARD : DuplicatePolicy.valueOf(str.toUpperCase());
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("duplicatePolicy", this.strategy.name());
        return element;
    }

    public DuplicatePolicy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(DuplicatePolicy strategy) {
        this.strategy = strategy;
    }

    @Override
    protected AbstractRule createDefaultRule() {
        return new ExpressionRule(this.category);
    }

    @Override
    protected void processResource(GeneratorResource resource) {
        DataReport sourceReport = this.loadSourceReport(resource);
        GeneratorContext context = this.getContext();
        DataReport destReport = context.getDestReport();
        if (sourceReport == null) {
            return;
        }
        if (sourceReport == destReport) {
            destReport = destReport.newInstance(false);
        }
        ReportMetaData meta = destReport.getMeta();
        List<AbstractRule> rules = this.getRules(meta, meta);
        Map<String, Integer> destIndexes = destReport.getRowIndexMap();
        for (DataRow sourceRow : sourceReport.getRows()) {
            DataRow destRow = null;
            String key = sourceRow.getRowKeyString();
            Integer i = destIndexes.get(key);
            if (i != null) {
                destRow = destReport.getRow(i);
            }
            if (destRow == null) {
                destIndexes.put(sourceRow.getRowKeyString(), destReport.getRowsCount());
                destReport.addRow(sourceRow);
                continue;
            }
            if (this.strategy == DuplicatePolicy.DISCARD) continue;
            context.setSourceRow(sourceRow);
            context.setDestRow(destRow);
            for (AbstractRule rule : rules) {
                this.executeRule(rule);
            }
        }
        context.setDestReport(destReport);
    }

    @Override
    protected AbstractRule createColumnRule(DataColumn column) {
        ExpressionRule rule = new ExpressionRule(this.category);
        String columnName = column.getColumnName();
        rule.setColumnName(columnName);
        if (column.getColumnName().equals("buildId")) {
            rule.setValueExpression("build.getId()");
        } else if (column.getDataType().isNumericType()) {
            rule.setValueExpression("current." + columnName + " + source." + columnName);
        } else if (column.getDataType() instanceof BooleanType) {
            rule.setValueExpression("source." + columnName + " && current." + columnName);
        } else {
            rule.setValueExpression("source." + columnName);
        }
        return rule;
    }

    @Override
    public String getType() {
        return "DUPLICATE";
    }
}

