/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.diff;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DiffProcessor
extends ExpressionProcessor {
    private static final long serialVersionUID = 1L;
    @Alias(name="diffColumns")
    private String diffColumnNames;

    public DiffProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        DataReport destReport = context.getDestReport();
        DataColumn[] diffColumns = this.getDiffColumns(destReport.getMeta());
        Map<String, Integer> sourceIndexes = sourceReport.getRowIndexMap(diffColumns);
        HashSet visited = Sets.newHashSet();
        for (DataRow row : destReport.getRows()) {
            String key = row.getRowKeyString(diffColumns);
            Integer i = sourceIndexes.get(key);
            DataRow previousRow = null;
            if (i != null && !visited.contains(i)) {
                previousRow = sourceReport.getRow(i);
                visited.add(i);
            }
            context.setDestRow(row);
            context.setSourceRow(previousRow);
            for (AbstractRule rule : this.getRules()) {
                this.executeRule(rule);
            }
        }
        for (int i = 0; i < sourceReport.getRowsCount(); ++i) {
            DataRow row;
            if (visited.contains(i)) continue;
            row = sourceReport.getRow(i);
            context.setDestRow(null);
            context.setSourceRow(row);
            for (AbstractRule rule : this.getRules()) {
                this.executeRule(rule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Build getPreviousBuild(Build currentBuild) {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = context.getReportCategory();
        String reportset = context.getReportSet();
        Grid buildGrid = (Grid)Quickbuild.getInstance(Grid.class);
        String str = null;
        File tempFile = FileUtils.createTempFile((String)"diff");
        try {
            GridNode serverNode = buildGrid.getServerNode();
            GridNode localNode = buildGrid.getLocalNode();
            String categoryPath = Quickbuild.getServerService().getConfigurationPublishDir(currentBuild.getConfiguration().getId()) + "/" + category.getCategoryRelativeDir();
            String srcFile = categoryPath + "/" + reportset + "/" + "latest.id";
            if (!serverNode.isFileExists(srcFile)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().warn("File [" + srcFile + "] doesn't exist.");
                }
                Build build = null;
                return build;
            }
            buildGrid.transferFile(serverNode, srcFile, localNode, tempFile.getAbsolutePath(), categoryPath, null);
            str = FileUtils.readFileAsString((File)tempFile);
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        List latestBuilds = (List)DataTypes.LIST_LONG.fromString(str, null);
        if (latestBuilds == null || latestBuilds.size() == 0) {
            return null;
        }
        Long currentId = currentBuild.getId();
        BuildManager bm = (BuildManager)Quickbuild.getInstance(BuildManager.class);
        Build b = null;
        Collections.reverse(latestBuilds);
        for (Long buildId : latestBuilds) {
            if (buildId == null || currentId <= buildId || (b = (Build)bm.get(buildId)) == null) continue;
            return b;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataReport loadSourceReport(GeneratorResource resource) {
        DataReport dataReport;
        block13: {
            String reportDirOnServer;
            String versionFileOnServer;
            GridNode localNode;
            GridNode serverNode;
            Grid buildGrid;
            File previousReportDir;
            ReportCategory category;
            Build previousBuild;
            File previousCategoryDir;
            DataReport sourceReport;
            block11: {
                DataReport dataReport2;
                block12: {
                    GeneratorContext context;
                    block9: {
                        DataReport dataReport3;
                        block10: {
                            context = this.getContext();
                            DataReport destReport = context.getDestReport();
                            sourceReport = destReport.newInstance(false);
                            Build currentBuild = context.getCurrentBuild();
                            if (currentBuild == null) {
                                return sourceReport;
                            }
                            previousCategoryDir = null;
                            previousBuild = this.getPreviousBuild(currentBuild);
                            if (previousBuild != null) break block9;
                            dataReport3 = sourceReport;
                            if (previousCategoryDir == null) break block10;
                            FileUtils.deleteDir(previousCategoryDir);
                        }
                        return dataReport3;
                    }
                    category = context.getReportCategory();
                    String reportset = context.getReportSet();
                    previousCategoryDir = FileUtils.createTempDir((String)"previouscategory");
                    previousReportDir = new File(previousCategoryDir, reportset);
                    FileUtils.createDir((File)previousReportDir);
                    buildGrid = (Grid)Quickbuild.getInstance(Grid.class);
                    serverNode = buildGrid.getServerNode();
                    localNode = buildGrid.getLocalNode();
                    versionFileOnServer = Quickbuild.getServerService().getBuildPublishDir(previousBuild.getId()) + "/" + category.getCategoryRelativeDir() + "/" + "category.version";
                    reportDirOnServer = Quickbuild.getServerService().getBuildPublishDir(previousBuild.getId()) + "/" + category.getReportSetRelativeDir(reportset);
                    if (serverNode.isFileExists(reportDirOnServer)) break block11;
                    this.getLogger().warn("Previous report dir [" + reportDirOnServer + "] doesn't exist on server node.");
                    dataReport2 = sourceReport;
                    if (previousCategoryDir == null) break block12;
                    FileUtils.deleteDir((File)previousCategoryDir);
                }
                return dataReport2;
            }
            try {
                File versionFile = new File(previousCategoryDir, "category.version");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Start transfering previous report from server [" + reportDirOnServer + "] to local [" + previousReportDir + "]");
                }
                buildGrid.transferFiles(serverNode, reportDirOnServer, "**", localNode, previousReportDir.getAbsolutePath(), false, reportDirOnServer, null);
                buildGrid.transferFile(serverNode, versionFileOnServer, localNode, versionFile.getAbsolutePath(), versionFileOnServer, null);
                MigrationContext mc = new MigrationContext();
                mc.setBuild(previousBuild);
                mc.setCurrentBean(category);
                mc.setDir(previousCategoryDir);
                category.upgrade(previousCategoryDir, mc);
                ReportDataSource dataSource = resource.getReportResource();
                dataReport = category.loadReport(previousReportDir, dataSource);
                if (previousCategoryDir == null) break block13;
            }
            catch (DatabaseException e) {
                DataReport dataReport4;
                block14: {
                    try {
                        this.getLogger().error("Load previous report " + sourceReport.getReportName() + " failed!", (Throwable)e);
                        dataReport4 = sourceReport;
                        if (previousCategoryDir == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (previousCategoryDir != null) {
                            FileUtils.deleteDir(previousCategoryDir);
                        }
                        throw throwable;
                    }
                    FileUtils.deleteDir((File)previousCategoryDir);
                }
                return dataReport4;
            }
            FileUtils.deleteDir((File)previousCategoryDir);
        }
        return dataReport;
    }

    protected DataColumn[] getDiffColumns(ReportMetaData meta) {
        if (Strings.isNullOrEmpty((String)this.diffColumnNames)) {
            return meta.getPrimaryColumns();
        }
        Iterator it = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.diffColumnNames).iterator();
        ArrayList list = Lists.newArrayList();
        while (it.hasNext()) {
            list.add(meta.getColumn((String)it.next()));
        }
        return (DataColumn[])Iterables.toArray((Iterable)list, DataColumn.class);
    }

    public String getDiffColumnNames() {
        return this.diffColumnNames;
    }

    public void setDiffColumnNames(String diffColumnNames) {
        this.diffColumnNames = diffColumnNames;
    }

    @Override
    public String getType() {
        return "DIFF";
    }
}

