/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.copy;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class CopyGenerator
extends AbstractGenerator {
    private static final long serialVersionUID = 1L;

    public CopyGenerator(ReportCategory category) {
        super(category);
    }

    @Override
    protected void doExecute() {
        Logger logger = this.getLogger();
        GeneratorContext context = this.getContext();
        String filePatterns = context.getFilePatterns();
        File destDir = context.getWorkingDir();
        File srcDir = context.getSourceDir();
        String msg = "Start copying files from '" + srcDir + "' to '" + destDir + "'";
        if (!StringUtils.isEmpty((String)filePatterns)) {
            msg = msg + " with pattern '" + filePatterns + "' ...";
        }
        logger.info(msg);
        FileUtils.copyFiles((File)srcDir, (String)filePatterns, (File)destDir);
        logger.info("Copying files finished successfully.");
    }

    public boolean isApplicable(Build build) {
        GeneratorContext context = this.getContext();
        File sourceDir = context.getSourceDir();
        if (!sourceDir.exists()) {
            return false;
        }
        String filePatterns = context.getFilePatterns();
        Collection files = FileUtils.listFiles((File)sourceDir, (String)filePatterns);
        return files.size() > 0;
    }

    @Override
    public String getType() {
        return "COPY";
    }
}

