/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.comparison;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportRelation;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ComparisonProcessor
extends ExpressionProcessor {
    private static final long serialVersionUID = 1L;
    @Alias(name="match-expression")
    private String rowMatchExpression;

    public ComparisonProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        DataReport sourceReport = this.loadSourceReport(resource);
        if (sourceReport == null) {
            return;
        }
        DataReport destReport = context.getDestReport();
        DataColumn[] compareColumns = null;
        ReportMetaData meta = destReport.getMeta();
        if (StringUtils.isEmpty((String)this.rowMatchExpression)) {
            ReportCategory category = context.getReportCategory();
            ReportRelation relation = category.getRelation(destReport.getReportName(), sourceReport.getReportName());
            compareColumns = relation != null ? relation.getParentColumns() : meta.getPrimaryColumns();
        }
        List<AbstractRule> rules = this.getRules(meta, sourceReport.getMeta());
        Map<String, Integer> map = destReport.getRowIndexMap(compareColumns);
        for (DataRow sourceRow : sourceReport.getRows()) {
            DataRow destRow = null;
            String rowKey = sourceRow.getRowKeyString(compareColumns);
            if (StringUtils.isEmpty((String)this.rowMatchExpression)) {
                Integer index = map.get(rowKey);
                if (index != null) {
                    destRow = destReport.getRow(index);
                }
            } else {
                destRow = destReport.findRow(sourceRow, this.rowMatchExpression);
            }
            if (destRow == null) {
                destRow = destReport.addRow();
            }
            context.setSourceRow(sourceRow);
            context.setDestRow(destRow);
            for (AbstractRule rule : rules) {
                this.executeRule(rule);
            }
            map.put(rowKey, destRow.getId().intValue() - 1);
        }
    }

    public String getRowMatchExpression() {
        return this.rowMatchExpression;
    }

    public void setRowMatchExpression(String rowMatchExpression) {
        this.rowMatchExpression = rowMatchExpression;
    }

    @Override
    public String getType() {
        return "COMPARISON";
    }
}

