/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.bean;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.lang.reflect.Field;

public class Bean2ReportRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;

    public Bean2ReportRule(ReportCategory category) {
        super(category);
    }

    public Bean2ReportRule(ReportCategory category, String columnName, String beanFieldName) {
        super(category, columnName, beanFieldName);
    }

    @Override
    protected void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow row = context.getDestRow();
        Object bean = context.getSourceBean();
        Field field = BeanUtils.getField(bean.getClass(), (String)this.getValueExpression());
        if (field == null) {
            return;
        }
        try {
            boolean old = field.isAccessible();
            field.setAccessible(true);
            row.setValue(this.getColumnName(), field.get(bean));
            field.setAccessible(old);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    @Override
    public String getType() {
        return "BEAN_RULE";
    }
}

