/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator.bean;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.generator.reader.PassthroughReader;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.lang.reflect.Field;
import java.util.List;

public class Bean2ReportProcessor<T>
extends AbstractProcessor {
    private static final long serialVersionUID = 1L;

    public Bean2ReportProcessor(ReportCategory category) {
        super(category);
    }

    protected ResourceReader<T> createDefaultReader() {
        return new PassthroughReader();
    }

    @Override
    protected AbstractRule createDefaultRule() {
        return new ExpressionRule(this.category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(List<T> beans, DataReport destReport) throws Exception {
        try {
            GeneratorContext context = GeneratorContext.getContext();
            context.setDestReport(destReport);
            GeneratorResource resource = new GeneratorResource();
            resource.setPassthroughObject(beans);
            this.processResource(resource);
        }
        finally {
            GeneratorContext.setContext(null);
        }
    }

    @Override
    protected void processResource(GeneratorResource resource) {
        GeneratorContext context = this.getContext();
        List beans = (List)resource.getPassthroughObject();
        if (beans == null || beans.size() == 0) {
            return;
        }
        DataReport report = context.getDestReport();
        DataColumn[] columns = this.getNonCalcColumns(report.getMeta());
        Class<?> clazz = beans.get(0).getClass();
        for (Object obj : beans) {
            DataRow row = report.addRow();
            for (DataColumn column : columns) {
                Field field = BeanUtils.getField(clazz, (String)column.getColumnName());
                if (field == null) continue;
                boolean old = field.isAccessible();
                try {
                    field.setAccessible(true);
                    row.setValue(column.getColumnName(), field.get(obj));
                    field.setAccessible(old);
                }
                catch (IllegalArgumentException e) {
                    throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                }
            }
            context.setDestRow(row);
            context.setSourceBean(obj);
            for (AbstractRule rule : this.getRules()) {
                this.executeRule(rule);
            }
        }
    }

    @Override
    public String getType() {
        return "BEAN_PROCESSOR";
    }
}

