/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.datareport.UnProcessedReport;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ExecutionContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;

public class GeneratorContext
extends ExecutionContext {
    private static final long serialVersionUID = 1L;
    private static GeneratorContextThreadLocal executionContext = new GeneratorContextThreadLocal();
    public static final String DEST_REPORT = "generator.context.destreport";
    public static final String LOCALE = "generator.context.locale";
    public static final String CURRENT_BUILD = "generator.context.currentbuild";
    public static final String REPORT_CATEGORY = "generator.context.reportcategory";
    public static final String WORKSPACE_DIR = "generator.context.workspacedir";
    public static final String WORKING_DIR = "generator.context.workingdir";
    public static final String SOURCE_DIR = "generator.context.sourcedir";
    public static final String GENERATE_STAGE = "generator.context.generatestage";
    public static final String FILE_PATTERNS = "generator.context.filepatterns";
    public static final String CURRENT_ELEMENT = "generator.context.currentelement";
    public static final String SOURCE_ROW = "generator.context.sourcerow";
    public static final String DEST_ROW = "generator.context.destrow";
    public static final String REPORT_STATS = "generator.context.reportstats";
    public static final String RESOURCES = "generator.context.resources";
    public static final String PROCESSOR_RESOURCE = "generator.context.resource";
    public static final String LOADING_OPTIONS = "generator.context.loadingoptions";
    public static final String PASSTHROUGH_OBJECT = "generator.context.passthroughobject";
    public static final String SOURCE_BEAN = "generator.context.sourcebean";
    public static final String PARAMS = "generator.context.params";
    public static final String SUB_REPORT_NAME = "generator.context.subreport.name";
    public static final String ERROR_CONTEXT = "generator.context.errorcontext";
    public static final String UNPROCESSED_REPORT = "generator.context.unprocessedreport";
    private static final String AUTO_ID = "generator.context.autoid";
    public static final String REPORTSET_IS_EMPTY = "generator.context.reportset.is.empty";

    public DataReport getDestReport() {
        return (DataReport)this.get(DEST_REPORT);
    }

    public void setDestReport(DataReport report) {
        this.put(DEST_REPORT, report);
    }

    public Locale getLocale() {
        return (Locale)this.get(LOCALE);
    }

    public void setLocale(Locale locale) {
        this.put(LOCALE, locale);
    }

    public Build getCurrentBuild() {
        return (Build)this.get(CURRENT_BUILD);
    }

    public void setCurrentBuild(Build build) {
        this.put(CURRENT_BUILD, build);
    }

    public File getWorkingDir() {
        return (File)this.get(WORKING_DIR);
    }

    public void setWorkingDir(File workingDir) {
        this.put(WORKING_DIR, workingDir);
    }

    public String getWorkspaceDir() {
        return (String)this.get(WORKSPACE_DIR);
    }

    public void setWorkspaceDir(String workspaceDir) {
        this.put(WORKSPACE_DIR, workspaceDir);
    }

    public GeneratorStage getGenerateStage() {
        return (GeneratorStage)((Object)this.get(GENERATE_STAGE));
    }

    public void setGenerateStage(GeneratorStage stage) {
        this.put(GENERATE_STAGE, (Object)stage);
    }

    public DataRow getDestRow() {
        return (DataRow)this.get(DEST_ROW);
    }

    public void setDestRow(DataRow row) {
        this.put(DEST_ROW, row);
    }

    public DataRow getSourceRow() {
        return (DataRow)this.get(SOURCE_ROW);
    }

    public void setSourceRow(DataRow row) {
        this.put(SOURCE_ROW, row);
    }

    public ReportCategory getReportCategory() {
        return (ReportCategory)this.get(REPORT_CATEGORY);
    }

    public void setReportCategory(ReportCategory category) {
        this.put(REPORT_CATEGORY, category);
    }

    public ReportStats getReportStats() {
        return (ReportStats)this.get(REPORT_STATS);
    }

    public void setReportStats(ReportStats stats) {
        this.put(REPORT_STATS, stats);
    }

    public File getSourceDir() {
        return (File)this.get(SOURCE_DIR);
    }

    public void setSourceDir(File file) {
        this.put(SOURCE_DIR, file);
    }

    public String getFilePatterns() {
        return (String)this.get(FILE_PATTERNS);
    }

    public void setFilePatterns(String patterns) {
        this.put(FILE_PATTERNS, patterns);
    }

    public GeneratorResource[] getResources() {
        return (GeneratorResource[])this.get(RESOURCES);
    }

    public void setResources(GeneratorResource[] resources) {
        this.put(RESOURCES, resources);
    }

    public Object getResource() {
        return this.get(PROCESSOR_RESOURCE);
    }

    public void setResource(Object obj) {
        this.put(PROCESSOR_RESOURCE, obj);
    }

    public String getReportSet() {
        return (String)this.get(SUB_REPORT_NAME);
    }

    public void setReportSet(String reportset) {
        this.put(SUB_REPORT_NAME, reportset);
    }

    public void setReportsetIsEmpty(boolean b) {
        this.put(REPORTSET_IS_EMPTY, b);
    }

    public boolean isReportsetEmpty() {
        Boolean b = (Boolean)this.get(REPORTSET_IS_EMPTY);
        return b == null ? false : b;
    }

    public Map<String, Object> getParams() {
        return (Map)this.get(PARAMS);
    }

    public void setParams(Map<String, Object> params) {
        this.put(PARAMS, params);
    }

    public Element getCurrentElement() {
        return (Element)this.get(CURRENT_ELEMENT);
    }

    public void setCurrentElement(Element element) {
        this.put(CURRENT_ELEMENT, element);
    }

    public Object getSourceBean() {
        return this.get(SOURCE_BEAN);
    }

    public void setSourceBean(Object obj) {
        this.put(SOURCE_BEAN, obj);
    }

    public static int getNextId() {
        Integer i = (Integer)GeneratorContext.getContext().get(AUTO_ID);
        if (i == null) {
            i = 1;
            GeneratorContext.getContext().put(AUTO_ID, i);
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return i;
    }

    public List<Throwable> getErrorContext() {
        ArrayList<Throwable> errors = (ArrayList<Throwable>)this.get(ERROR_CONTEXT);
        if (errors == null) {
            errors = new ArrayList<Throwable>();
            this.setErrorContext(errors);
        }
        return errors;
    }

    public void setErrorContext(List<Throwable> errors) {
        this.put(ERROR_CONTEXT, errors);
    }

    public UnProcessedReport getUnProcessedReport() {
        return (UnProcessedReport)this.get(UNPROCESSED_REPORT);
    }

    public void setUnProcessedReport(UnProcessedReport report) {
        this.put(UNPROCESSED_REPORT, report);
    }

    public static void setContext(GeneratorContext context) {
        executionContext.set(context);
    }

    public static GeneratorContext getContext() {
        GeneratorContext context = (GeneratorContext)executionContext.get();
        if (context == null) {
            context = new GeneratorContext();
            GeneratorContext.setContext(context);
        }
        return context;
    }

    public String dump() {
        ReportStats stats;
        Map<String, Object> params;
        Element element;
        DataRow sourceRow;
        DataRow destRow;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String reportset = this.getReportSet();
        if (reportset != null) {
            sb.append("Report Set: " + reportset);
        } else {
            sb.append("Report Set: DEFAULT");
        }
        DataReport report = this.getDestReport();
        if (report != null) {
            sb.append(", Dest Report: [" + report.getReportName()).append("]");
        }
        if ((destRow = this.getDestRow()) != null) {
            sb.append(", Dest Row: [" + destRow).append("]");
        }
        if ((sourceRow = this.getSourceRow()) != null) {
            sb.append(", Source Row: [" + sourceRow).append("]");
        }
        if ((element = this.getCurrentElement()) != null) {
            sb.append(", Current Element: [" + element.asXML()).append("]");
        }
        if ((params = this.getParams()) != null) {
            sb.append(", Params: [");
            for (String key : params.keySet()) {
                sb.append(key).append(params.get(key));
                sb.append(",");
            }
            sb.append("]");
        }
        if ((stats = this.getReportStats()) != null) {
            sb.append(", Report Stats: [").append(stats.getStats()).append("]");
        }
        return sb.toString();
    }

    private static class GeneratorContextThreadLocal
    extends ThreadLocal<GeneratorContext> {
        private GeneratorContextThreadLocal() {
        }

        @Override
        protected GeneratorContext initialValue() {
            return new GeneratorContext();
        }
    }
}

