/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.pmease.quickbuild.log.BuildLogger;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ActionListener;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenerateAction
extends AbstractCategoryItem
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GenerateAction.class);
    @Alias(name="id")
    private String id;
    @Alias(name="order")
    private int order = 9999;

    protected abstract void doExecute();

    public GenerateAction(ReportCategory category) {
        super(category);
    }

    public static String buildKey(String shortKey) {
        return GenerateAction.class.getName() + shortKey;
    }

    public void execute() {
        this.beforeExecute();
        this.doExecute();
        this.afterExecute();
    }

    public Logger getLogger() {
        BuildLogger logger;
        Build build = this.getContext().getCurrentBuild();
        if (build != null && (logger = build.getLogger()) != null) {
            return logger;
        }
        return GenerateAction.logger;
    }

    protected GeneratorContext getContext() {
        return GeneratorContext.getContext();
    }

    @Override
    public void beforeExecute() {
    }

    @Override
    public void afterExecute() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

