/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.generator.NoResourceFoundException;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class DefaultGenerator
extends AbstractGenerator {
    private static final long serialVersionUID = 1L;
    @Alias(name="report")
    private String destReportName;

    public DefaultGenerator(ReportCategory category) {
        super(category);
    }

    @Override
    public void generate() {
        try {
            super.execute();
        }
        catch (NoResourceFoundException e) {
            this.getLogger().warn("No input resource found for generating report '" + this.destReportName + "'");
        }
    }

    @Override
    public void beforeExecute() {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            logger.info("Start generating report '" + this.destReportName + "'.");
        }
        this.getContext().setDestReport(this.createDestReport());
    }

    @Override
    public void afterExecute() {
        this.saveDestReport();
        this.clearContext();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Finished generating report '" + this.destReportName + "' successfully.");
        }
    }

    protected void clearContext() {
        GeneratorContext context = this.getContext();
        context.setResource(null);
        context.setResources(null);
        context.setDestReport(null);
    }

    protected boolean isReportValid(DataReport destReport) {
        return destReport != null && !destReport.isEmpty();
    }

    protected MergeFunction<DataRow> getMergeFunction() {
        return null;
    }

    protected void saveDestReport() {
        File dbDir = this.getContext().getWorkingDir();
        this.getCategory().saveReport(dbDir, this.getContext().getDestReport(), this.getMergeFunction());
    }

    protected boolean isBuildStage() {
        return this.getStage() == GeneratorStage.BUILD;
    }

    protected DataReport createDestReport() {
        if (!Strings.isNullOrEmpty((String)this.destReportName)) {
            return this.getCategory().createReport(this.destReportName);
        }
        return null;
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    public String getDestReportName() {
        return this.destReportName;
    }

    public void setDestReportName(String destReportName) {
        this.destReportName = destReportName;
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.getId())) {
            return this.destReportName;
        }
        return this.getId();
    }
}

