/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.generator.GenerateAction;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRule
extends GenerateAction {
    private static final long serialVersionUID = 1L;
    @Alias(name="column")
    private String columnName;
    @Alias(name="value")
    private String valueExpression;

    public AbstractRule(ReportCategory category) {
        super(category);
    }

    public AbstractRule(ReportCategory category, String columnName, String valueExpression) {
        super(category);
        this.columnName = columnName;
        this.valueExpression = valueExpression;
    }

    protected Map<String, Object> prepareExpressionContext() {
        GeneratorContext context = this.getContext();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WORKSPACE_DIR", context.getWorkspaceDir());
        map.put("utils", ReportUtils.getInstance());
        map.put("build", context.getCurrentBuild());
        if (context.getParams() != null) {
            map.put("PARAMS", context.getParams());
        }
        if (context.getCurrentElement() != null) {
            map.put("node", context.getCurrentElement());
        }
        if (context.getSourceRow() != null) {
            map.put("source", context.getSourceRow().toMap());
        } else {
            map.put("source", null);
        }
        if (context.getDestRow() != null) {
            map.put("current", context.getDestRow().toMap());
        } else {
            map.put("current", null);
        }
        return map;
    }

    protected boolean hasColumn(String columnName) {
        for (String each : this.forColumns()) {
            if (!each.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    protected String[] forColumns() {
        return new String[]{this.columnName};
    }

    @Override
    public String getElementName() {
        return "rule";
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Type: " + this.getType());
        if (!StringUtils.isEmpty((String)this.columnName)) {
            sb.append(", Column: " + this.columnName);
        }
        return sb.toString();
    }
}

