/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildListener;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportBuildListener
implements BuildListener {
    private static Logger logger = LoggerFactory.getLogger(AbstractReportBuildListener.class);
    protected transient File reportsetDir;

    public abstract boolean isApplicable();

    protected abstract ReportCategory getCategory();

    protected abstract AbstractGenerator[] getGenerators();

    public void buildFinished() {
        ReportCategory category = this.getCategory();
        if (!this.isApplicable()) {
            this.getLogger().debug("Build listener for category [" + category.getId() + "] is not applicable.");
            return;
        }
        this.getLogger().info("Start build listener for category " + category.getId() + " ...");
        Build build = Context.getBuild();
        GeneratorContext context = GeneratorContext.getContext();
        context.setCurrentBuild(Context.getBuild());
        context.setReportCategory(this.getCategory());
        context.setReportSet(this.getReportSet());
        context.setGenerateStage(GeneratorStage.BUILD);
        File reportDir = category.createCategoryDirOfBuild(build);
        this.reportsetDir = category.getReportDirOfBuild(build, this.getReportSet());
        if (!this.reportsetDir.exists()) {
            FileUtils.createDir((File)this.reportsetDir);
        }
        context.setWorkingDir(reportDir);
        this.generateReports();
    }

    protected void generateReports() {
        AbstractGenerator[] generators;
        for (AbstractGenerator generator : generators = this.getGenerators()) {
            this.getLogger().info("Executing generator [" + generator.getId() + "]");
            generator.generate();
        }
    }

    protected String getReportSet() {
        return "DEFAULT";
    }

    protected Logger getLogger() {
        Logger l = Context.getLogger();
        if (l == null) {
            return logger;
        }
        return l;
    }

    public void buildStarted() {
    }

    public void jobFinished(GridJob job) {
    }

    public void jobStarted(GridJob job) {
    }
}

