/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.google.common.base.Throwables;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datareport.UnProcessedReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.exception.MalFormedXMLException;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportGenerateException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractRule;
import com.pmease.quickbuild.plugin.report.engine.generator.GenerateAction;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.generator.NoResourceFoundException;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractProcessor
extends GenerateAction {
    private static final long serialVersionUID = 1L;
    private List<AbstractRule> rules = new LinkedList<AbstractRule>();
    private String readerType;
    private List<ReportDataSource> resources = new ArrayList<ReportDataSource>();

    protected abstract AbstractRule createDefaultRule();

    protected abstract ResourceReader<?> createDefaultReader();

    protected abstract void processResource(GeneratorResource var1);

    public AbstractProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    protected void doExecute() {
        GeneratorResource[] resources;
        for (GeneratorResource resource : resources = this.getGeneratorResources()) {
            File file = resource.getFile();
            if (this.getLogger().isDebugEnabled()) {
                ReportDataSource reportResource;
                if (file != null) {
                    this.getLogger().info("Start processing file: " + file);
                }
                if ((reportResource = resource.getReportResource()) != null) {
                    this.getLogger().info("Start processing report: " + reportResource.getFrom());
                }
            }
            if (resource.isFileEmpty()) {
                this.getLogger().warn("Skip processing resource [" + resource + "], the file is empty.");
                continue;
            }
            try {
                this.processResource(resource);
            }
            catch (Exception e) {
                Throwable de = ExceptionUtils.extractException((Throwable)e, DocumentException.class);
                Throwable sax = ExceptionUtils.extractException((Throwable)e, SAXException.class);
                Throwable stax = ExceptionUtils.extractException((Throwable)e, XMLStreamException.class);
                if (de != null || sax != null || stax != null) {
                    this.getLogger().warn("Processing resource " + resource + " failed.", (Throwable)e);
                    if (file != null) {
                        this.processMalFormedReport(file, e);
                    }
                }
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    protected void processMalFormedReport(File file, Throwable e) {
        DataRow row;
        if (this.getContext().getGenerateStage() == GeneratorStage.STATISTICS) {
            return;
        }
        if (!this.category.hasUnProcessedReport()) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        UnProcessedReport r = this.getContext().getUnProcessedReport();
        String reportset = this.getContext().getReportSet();
        String fileName = file.getName();
        if (StringUtils.isEmpty((String)reportset)) {
            reportset = "DEFAULT";
        }
        if ((row = r.findRow(new Pair[]{new Pair((Object)"REPORT_SET", (Object)reportset), new Pair((Object)"FILE_NAME", (Object)fileName)})) != null) {
            return;
        }
        row = r.addRow();
        row.setValue("REPORT_SET", (Object)this.getContext().getReportSet());
        row.setValue("FILE_NAME", (Object)file.getName());
        String content = FileUtils.readFileAsString((File)file);
        row.setValue("CONTENT", (Object)content);
        row.setValue("REASON", (Object)org.apache.commons.lang.exception.ExceptionUtils.getMessage((Throwable)e));
    }

    protected void executeRule(AbstractRule rule) {
        try {
            rule.execute();
        }
        catch (Exception e) {
            Logger logger = this.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug(this.getContext().dump());
            }
            throw new ReportGenerateException("Executing rule [" + rule + "@" + this + "] failed.", e);
        }
    }

    protected GeneratorResource[] getGeneratorResources() {
        String filePatterns;
        GeneratorContext context = this.getContext();
        if (this.resources.size() > 0) {
            GeneratorResource[] inputResources = new GeneratorResource[this.resources.size()];
            for (int i = 0; i < inputResources.length; ++i) {
                inputResources[i] = new GeneratorResource(this.resources.get(i), this.getReportResourceFile(this.resources.get(i).getFrom()));
            }
            return inputResources;
        }
        GeneratorResource[] inputResources = context.getResources();
        if (inputResources != null && inputResources.length > 0) {
            return inputResources;
        }
        File sourceDir = context.getSourceDir();
        File[] files = FileUtils.listFiles((File)sourceDir, (String)(filePatterns = context.getFilePatterns())).toArray(new File[0]);
        if (files.length == 0) {
            throw new NoResourceFoundException("No input resource for processor " + this);
        }
        inputResources = new GeneratorResource[files.length];
        for (int i = 0; i < files.length; ++i) {
            inputResources[i] = new GeneratorResource(null, files[i]);
        }
        return inputResources;
    }

    protected File getReportResourceFile(String reportName) {
        GeneratorContext context = this.getContext();
        ReportCategory category = this.getCategory();
        ReportMetaData meta = category.getMeta(reportName);
        if (meta == null) {
            throw new ReportException("Meta data for report '" + reportName + "' is undefined.");
        }
        ReportGroup group = meta.getGroup();
        GeneratorStage stage = context.getGenerateStage();
        if (stage == GeneratorStage.BUILD) {
            if (group == ReportGroup.STATISTICS || group == ReportGroup.HISTORY) {
                throw new ReportGenerateException("For generate build report, do not retrieve data from statistics.");
            }
            return context.getWorkingDir();
        }
        if (stage == GeneratorStage.STATISTICS) {
            if (group == ReportGroup.STATISTICS || group == ReportGroup.HISTORY) {
                return context.getWorkingDir();
            }
            return context.getSourceDir();
        }
        return null;
    }

    @Override
    public void afterExecute() {
        GeneratorContext context = this.getContext();
        DataReport destReport = context.getDestReport();
        context.setResources(new GeneratorResource[]{new GeneratorResource(destReport)});
    }

    @Override
    public void beforeExecute() {
        GeneratorResource[] resources = this.getGeneratorResources();
        if (resources == null || resources.length == 0) {
            throw new ReportException(this + " has no input resource for processing.");
        }
    }

    @Override
    public String getElementName() {
        return "processor";
    }

    protected ResourceReader<?> createReader() {
        if (StringUtils.isEmpty((String)this.readerType)) {
            return this.createDefaultReader();
        }
        return TypedObjects.createTypedObject(this.readerType, ResourceReader.class, new Object[0]);
    }

    protected DataColumn[] getNonCalcColumns(ReportMetaData meta) {
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        for (DataColumn column : meta.getColumns()) {
            if (this.getRule(column) != null) continue;
            columns.add(column);
        }
        return columns.toArray(new DataColumn[0]);
    }

    protected AbstractRule getRule(DataColumn column) {
        String columnName = column.getColumnName();
        for (AbstractRule rule : this.getRules()) {
            if (!rule.hasColumn(columnName)) continue;
            return rule;
        }
        return null;
    }

    @Override
    public void fromXML(Element node) throws ReportException {
        super.fromXML(node);
        if (StringUtils.isEmpty((String)this.getId())) {
            throw new MalFormedXMLException("Attribute 'id' is required for defining processor.");
        }
        this.readerType = XMLHelper.getString((Node)node, "reader");
        List resourceElements = node.selectNodes("data-source");
        this.resources.clear();
        for (Element element : resourceElements) {
            ReportDataSource resource = new ReportDataSource(this.getCategory());
            resource.fromXML(element);
            this.resources.add(resource);
        }
        List elements = node.selectNodes("./rule");
        this.rules.clear();
        for (Element ruleElement : elements) {
            AbstractRule rule = TypedObjects.createTypedObject(ruleElement, AbstractRule.class, this.createDefaultRule(), this.category);
            rule.fromXML(ruleElement);
            this.rules.add(rule);
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("reader", this.readerType);
        for (ReportDataSource resource : this.resources) {
            element.add(resource.toXML());
        }
        for (AbstractRule rule : this.rules) {
            element.add(rule.toXML());
        }
        return element;
    }

    public void addRule(AbstractRule rule) {
        this.rules.add(rule);
    }

    public List<AbstractRule> getRules() {
        return this.rules;
    }

    public void setRules(List<AbstractRule> rules) {
        this.rules = rules;
    }

    public String getReaderType() {
        return this.readerType;
    }

    public void setReaderType(String readerType) {
        this.readerType = readerType;
    }

    public List<ReportDataSource> getResources() {
        return this.resources;
    }

    public void setResources(List<ReportDataSource> resources) {
        this.resources = resources;
    }

    public String toString() {
        return this.getId() + " (" + this.getType() + ")";
    }
}

