/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.generator;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ReportGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.GenerateAction;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;
import org.slf4j.Logger;

public abstract class AbstractGenerator
extends GenerateAction
implements ReportGenerator {
    private static final long serialVersionUID = 1L;
    @Alias(name="stage")
    private GeneratorStage stage = GeneratorStage.BUILD;
    private List<AbstractProcessor> processors = new LinkedList<AbstractProcessor>();

    public AbstractGenerator(ReportCategory category) {
        super(category);
    }

    @Override
    protected void doExecute() {
        Logger logger = this.getLogger();
        for (AbstractProcessor processor : this.processors) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing processor [" + processor + "] ...");
            }
            processor.execute();
        }
    }

    @Override
    public String getElementName() {
        return "generator";
    }

    @Override
    public void generate() {
        this.execute();
    }

    public AbstractProcessor createDefaultProcessor() {
        return null;
    }

    public void addProcessor(AbstractProcessor processor) {
        this.processors.add(processor);
    }

    @Override
    public void fromXML(Element element) throws ReportException {
        super.fromXML(element);
        List elements = element.selectNodes("./processor");
        this.processors.clear();
        for (Element node : elements) {
            AbstractProcessor processor = TypedObjects.createTypedObject(node, AbstractProcessor.class, this.createDefaultProcessor(), this.category);
            if (processor == null) continue;
            processor.fromXML(node);
            this.processors.add(processor);
        }
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = super.toXML();
        element.addAttribute("stage", this.stage.name());
        for (AbstractProcessor processor : this.processors) {
            element.add(processor.toXML());
        }
        return element;
    }

    public GeneratorStage getStage() {
        return this.stage;
    }

    public void setStage(GeneratorStage stage) {
        this.stage = stage;
    }

    public List<AbstractProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<AbstractProcessor> processors) {
        this.processors = processors;
    }
}

