/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.extensionpoint;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExecutionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_BEAN = "executioncontext.currentbean";
    private volatile boolean dirty = false;
    private Map<String, Object> map;

    public ExecutionContext() {
        this.map = new HashMap<String, Object>();
    }

    public ExecutionContext(Map<String, Object> map) {
        this.map = new HashMap<String, Object>(map);
    }

    public ExecutionContext(ExecutionContext executionContext) {
        this();
        if (executionContext != null) {
            for (Map.Entry<String, Object> entry : executionContext.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void put(String key, Object value) {
        if (value != null) {
            this.map.put(key, value);
        } else {
            this.map.remove(key);
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Object get(String key, Object defaultValue) {
        Object obj = this.get(key);
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public <T> T readAndValidate(String key, Class<T> type) {
        Object value = this.map.get(key);
        if (!type.isInstance(value)) {
            throw new ClassCastException("Value for key=[" + key + "] is not of type: [" + type + "], it is [" + (value == null ? null : "(" + value.getClass() + ")" + value) + "]");
        }
        return (T)value;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExecutionContext rhs = (ExecutionContext)obj;
        return ((Object)this.entrySet()).equals(rhs.entrySet());
    }

    public Object getCurrentBean() {
        return this.get(CURRENT_BEAN);
    }

    public void setCurrentBean(Object obj) {
        this.put(CURRENT_BEAN, obj);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
        this.dirty = false;
    }

    public Map<String, Object> getContextMap() {
        return this.map;
    }

    public void setContextMap(Map<String, Object> map) {
        this.map = map;
    }
}

