/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.extensionpoint;

import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.TypedObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.XMLSerializable;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class AbstractTypedXMLObject
implements TypedObject,
XMLSerializable {
    private static final long serialVersionUID = 1L;

    public abstract String getElementName();

    @Override
    public void fromXML(Element node) {
        this.reflectionReadFromNode(node);
    }

    @Override
    public Element toXML() throws ReportException {
        Element element = DocumentHelper.createElement((String)this.getElementName());
        if (StringUtils.isEmpty((String)this.getType())) {
            element.addAttribute("class", this.getClass().getName());
        } else if (!this.getType().equalsIgnoreCase("DEFAULT")) {
            element.addAttribute("type", this.getType());
        }
        this.reflectionWriteToNode(element);
        return element;
    }

    protected void reflectionReadFromNode(Element node) {
        XMLHelper.reflectionFromXML(this, node);
    }

    protected void reflectionWriteToNode(Element node) {
        XMLHelper.reflectionToXML(this, node);
    }

    public void initFromStream(Class<?> clazz, String xml) {
        InputStream in = clazz.getResourceAsStream(xml);
        if (in == null) {
            throw new ReportException("File " + xml + " not exists");
        }
        Document doc = XMLHelper.readXML(in);
        this.fromXML(doc.getRootElement());
    }

    public void initFromClassResource(Class<?> clazz) {
        this.initFromStream(clazz, clazz.getSimpleName() + ".xml");
    }

    public void initFromLocal() {
        this.initFromClassResource(this.getClass());
    }
}

