/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.util.DateUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.validator.routines.TimeValidator;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class TimeType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            try {
                Long mills = Long.valueOf(str);
                if (mills != null) {
                    return TimeType.newCalendar(mills);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            DateTime date = ISODateTimeFormat.dateTime().parseDateTime(str);
            if (date == null) {
                throw new TypeCastException((Object)str, this);
            }
            java.util.Date d = date.toDate();
            return TimeType.newCalendar(d.getTime());
        }
        return TimeValidator.getInstance().validate(str, pattern, locale, Context.getTimeZone());
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Calendar cal = this.typeCast(value);
        if (cal == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return ISODateTimeFormat.dateTime().print(cal.getTimeInMillis());
        }
        if ("age".equalsIgnoreCase(pattern)) {
            return DateUtils.formatAge((java.util.Date)new java.util.Date(cal.getTimeInMillis()));
        }
        return TimeValidator.getInstance().format((Object)cal, pattern, locale, Context.getTimeZone());
    }

    @Override
    public Calendar typeCast(Object other) {
        if (other == null) {
            return null;
        }
        if (other instanceof Calendar) {
            return (Calendar)other;
        }
        if (other instanceof java.util.Date) {
            return TimeType.newCalendar(((java.util.Date)other).getTime());
        }
        if (other instanceof Date) {
            long mills = ((Date)other).getTime();
            return TimeType.newCalendar(mills);
        }
        if (other instanceof Time) {
            long mills = ((Time)other).getTime();
            return TimeType.newCalendar(mills);
        }
        if (other instanceof Timestamp) {
            long mills = ((Timestamp)other).getTime();
            return TimeType.newCalendar(mills);
        }
        if (other instanceof Number) {
            long mills = ((Number)other).longValue();
            return TimeType.newCalendar(mills);
        }
        if (other instanceof String) {
            return (Calendar)this.fromString((String)other);
        }
        throw new TypeCastException(other, this);
    }

    static Calendar newCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    @Override
    public String getDefaultPattern() {
        return "HH:mm:ss";
    }

    @Override
    public Class<?> getReturnedClass() {
        return Calendar.class;
    }

    @Override
    public String getSqlType() {
        return "TIMESTAMP";
    }

    @Override
    public Object asDbObject(Object original) {
        Calendar cal = this.typeCast(original);
        if (cal == null) {
            return null;
        }
        return new Timestamp(cal.getTimeInMillis());
    }

    public Object fromDbObject(Object original) {
        return this.typeCast(original);
    }

    @Override
    public String getType() {
        return "TIME";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            Timestamp time = rs.getTimestamp(columnName);
            return this.typeCast(time);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

