/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class StringType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        return str;
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Object typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof String) {
            return from;
        }
        return from.toString();
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return String.class;
    }

    @Override
    public String getSqlType() {
        return "VARCHAR";
    }

    @Override
    public Object asDbObject(Object original) {
        return this.typeCast(original);
    }

    @Override
    public String getType() {
        return "STRING";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return rs.getString(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

