/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.DoubleType;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.validator.routines.PercentValidator;

public class PercentType
extends DoubleType {
    private static final long serialVersionUID = 1L;

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Double d = this.typeCast(value);
        if (d == null || d.isInfinite() || d.isNaN()) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return d.toString();
        }
        return PercentValidator.getInstance().format((Object)d, pattern, locale);
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            try {
                return Double.valueOf(str);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        BigDecimal d = PercentValidator.getInstance().validate(str, pattern, locale);
        return d.doubleValue();
    }

    @Override
    public String getDefaultPattern() {
        return "0.00%";
    }

    @Override
    public String getType() {
        return "PERCENT";
    }
}

