/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.engine.annotation.NodeType;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractDataType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class ObjectType
extends AbstractDataType {
    private static final long serialVersionUID = 1L;

    public ObjectType() {
        super(NodeType.ELEMENT);
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        return VersionedDocument.xstream.fromXML(str);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Object obj = this.typeCast(value);
        if (obj == null) {
            return null;
        }
        return VersionedDocument.xstream.toXML(obj);
    }

    @Override
    public Object typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (this.getReturnedClass().isAssignableFrom(from.getClass())) {
            return from;
        }
        if (from instanceof String) {
            return this.fromString((String)from);
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return Object.class;
    }

    @Override
    public String getSqlType() {
        return "VARCHAR";
    }

    @Override
    public Object asDbObject(Object original) {
        Object obj = this.typeCast(original);
        if (obj == null) {
            return null;
        }
        return this.asString(obj);
    }

    public Object fromDbObject(Object original) {
        String str = (String)original;
        return this.fromString(str);
    }

    @Override
    public String getType() {
        return "OBJECT";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            String str = rs.getString(columnName);
            return this.typeCast(str);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

