/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractNumericType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.LongValidator;

public class LongType
extends AbstractNumericType {
    private static final long serialVersionUID = 1L;

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        BigDecimal number;
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("NaN".equalsIgnoreCase(str)) {
            return 0L;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException e) {
                try {
                    return new BigDecimal(str).longValue();
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
            }
        }
        if ((number = BigDecimalValidator.getInstance().validate(str, pattern, locale)) != null) {
            return ((Number)number).longValue();
        }
        return null;
    }

    @Override
    public Long getDefaultValue() {
        return 0L;
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Long l = this.typeCast(value);
        if (l == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return l.toString();
        }
        return LongValidator.getInstance().format((Object)l, pattern, locale);
    }

    @Override
    public Long typeCast(Object from) {
        Number number = this.toNumber(from);
        if (number == null) {
            return null;
        }
        return number.longValue();
    }

    @Override
    public String getDefaultPattern() {
        return "#,###";
    }

    @Override
    public Class<?> getReturnedClass() {
        return Long.class;
    }

    @Override
    public String getSqlType() {
        return "BIGINT";
    }

    @Override
    public String getType() {
        return "LONG";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return rs.getLong(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

