/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractCollectionType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVEscape;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ListType
extends AbstractCollectionType {
    private static final long serialVersionUID = 1L;

    public ListType() {
    }

    public ListType(DataType itemType) {
        super(itemType);
    }

    @Override
    public List typeCast(Object from) {
        return this.typeCast(from, null);
    }

    public List typeCast(Object from, String pattern) {
        if (from == null) {
            return null;
        }
        if (from instanceof List) {
            return (List)from;
        }
        if (from instanceof Collection) {
            Collection c = (Collection)from;
            List list = this.getDefaultValue();
            list.addAll(c);
            return list;
        }
        if (from.getClass().isArray()) {
            Object[] array = (Object[])from;
            List list = this.getDefaultValue();
            for (Object each : array) {
                list.add(this.itemType.typeCast(each));
            }
            return list;
        }
        if (from instanceof String) {
            return (List)this.fromString((String)from, pattern);
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public List getDefaultValue() {
        return new ArrayList();
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return List.class;
    }

    @Override
    public String getType() {
        return "LIST";
    }

    @Override
    public String asString(Object value, String pattern, String itemPattern, Locale locale) {
        if (value == null) {
            return null;
        }
        List list = this.typeCast(value, pattern);
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)list);
        }
        if (list.isEmpty()) {
            return null;
        }
        DataType itemType = this.getItemType();
        if (itemType == null) {
            itemType = DataTypes.getDataType(list.get(0));
        }
        StringWriter writer = new StringWriter();
        for (int i = 0; i < list.size(); ++i) {
            Object v = list.get(i);
            String str = itemType.asString(v, itemPattern, locale);
            if (pattern != null) {
                str = str + pattern;
            }
            CSVEscape.escapeCSV(writer, str, this.delimiter);
            if (i + 1 >= list.size()) continue;
            writer.write(this.delimiter);
        }
        return writer.toString();
    }

    @Override
    public List fromString(String str, String pattern, String itemPattern, Locale locale) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return (List)VersionedDocument.xstream.fromXML(str);
        }
        CSVParser parser = new CSVParser(this.delimiter);
        List<String> strArray = parser.tokenize(str);
        ArrayList<Object> list = new ArrayList<Object>();
        for (String s : strArray) {
            String real = pattern != null ? s.substring(0, s.length() - pattern.length()) : s;
            Object value = this.itemType.fromString(real, itemPattern, locale);
            list.add(value);
        }
        return list;
    }
}

