/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractNumericType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.IntegerValidator;

public class IntegerType
extends AbstractNumericType {
    private static final long serialVersionUID = 1L;

    @Override
    public Integer getDefaultValue() {
        return 0;
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        BigDecimal number;
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("NaN".equalsIgnoreCase(str)) {
            return 0;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                try {
                    return new BigDecimal(str).intValue();
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
            }
        }
        if ((number = BigDecimalValidator.getInstance().validate(str, pattern, locale)) != null) {
            return ((Number)number).intValue();
        }
        return null;
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Integer i = this.typeCast(value);
        if (i == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return i.toString();
        }
        return IntegerValidator.getInstance().format((Object)i, pattern, locale);
    }

    @Override
    public Integer typeCast(Object from) {
        Number number = this.toNumber(from);
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    @Override
    public String getDefaultPattern() {
        return "#,###";
    }

    @Override
    public Class<?> getReturnedClass() {
        return Integer.class;
    }

    @Override
    public String getSqlType() {
        return "INT";
    }

    @Override
    public String getType() {
        return "INTEGER";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return rs.getInt(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }

    public static void main(String[] argv) throws ParseException {
        System.out.println(Math.round(DecimalFormat.getInstance(Locale.GERMANY).parse("19,9").doubleValue()));
    }
}

