/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractCollectionType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVEscape;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class HashSetType
extends AbstractCollectionType {
    private static final long serialVersionUID = 1L;

    public HashSetType() {
    }

    public HashSetType(DataType itemType) {
        super(itemType);
    }

    @Override
    public Set typeCast(Object from) {
        if (from == null) {
            return null;
        }
        if (from instanceof Set) {
            return (Set)from;
        }
        if (from instanceof Collection) {
            Set set = this.getDefaultValue();
            set.addAll((Collection)from);
            return set;
        }
        if (from.getClass().isArray()) {
            Object[] array = (Object[])from;
            Set set = this.getDefaultValue();
            for (Object each : array) {
                set.add(this.itemType.typeCast(each));
            }
            return set;
        }
        if (from instanceof String) {
            return (Set)this.fromString((String)from, null);
        }
        throw new TypeCastException(from, this);
    }

    @Override
    public String getDefaultPattern() {
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return Set.class;
    }

    @Override
    public String getType() {
        return "SET";
    }

    @Override
    public String asString(Object value, String pattern, String itemPattern, Locale locale) {
        if (value == null) {
            return null;
        }
        Set set = this.typeCast(value);
        if (set.isEmpty()) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)set);
        }
        DataType itemType = this.getItemType();
        StringWriter writer = new StringWriter();
        int i = 0;
        for (Object v : set) {
            String str = itemType.asString(v, itemPattern, locale);
            if (pattern != null) {
                str = str + pattern;
            }
            CSVEscape.escapeCSV(writer, str, this.delimiter);
            if (i + 1 < set.size()) {
                writer.write(this.delimiter);
            }
            ++i;
        }
        return writer.toString();
    }

    @Override
    public Set getDefaultValue() {
        return new LinkedHashSet();
    }

    @Override
    public Object fromString(String str, String pattern, String itemPattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.fromXML(str);
        }
        CSVParser parser = new CSVParser(this.delimiter);
        List<String> strArray = parser.tokenize(str);
        Set list = this.getDefaultValue();
        DataType it = this.itemType;
        if (it == null) {
            it = DataTypes.STRING;
        }
        for (String s : strArray) {
            String real = pattern != null ? s.substring(0, s.length() - pattern.length()) : s;
            Object value = it.fromString(real, itemPattern, locale);
            list.add(value);
        }
        return list;
    }
}

