/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.datatype;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractNumericType;
import com.pmease.quickbuild.plugin.report.engine.exception.DatabaseException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.validator.routines.FloatValidator;

public class FloatType
extends AbstractNumericType {
    private static final long serialVersionUID = 1L;

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (pattern == null) {
            try {
                return Float.valueOf(str);
            }
            catch (NumberFormatException e) {
                return Float.valueOf(new BigDecimal(str).floatValue());
            }
        }
        return FloatValidator.getInstance().validate(str, pattern, locale);
    }

    @Override
    public String asString(Object value, String pattern, Locale locale) {
        Float f = this.typeCast(value);
        if (f == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)pattern)) {
            return f.toString();
        }
        return FloatValidator.getInstance().format((Object)f, pattern, locale);
    }

    @Override
    public Float typeCast(Object from) {
        Number n = this.toNumber(from);
        if (n == null) {
            return null;
        }
        return Float.valueOf(n.floatValue());
    }

    @Override
    public String getDefaultPattern() {
        return "#,##0.00";
    }

    @Override
    public Class<?> getReturnedClass() {
        return Float.class;
    }

    @Override
    public String getSqlType() {
        return "REAL";
    }

    @Override
    public String getType() {
        return "FLOAT";
    }

    @Override
    public Object fromDbObject(ResultSet rs, String columnName) {
        try {
            return Float.valueOf(rs.getFloat(columnName));
        }
        catch (SQLException e) {
            throw new DatabaseException("Retrieve column " + columnName + " with data type " + this + " failed.", e);
        }
    }
}

